/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.plugin.database;

import com.mysql.cj.jdbc.MysqlDataSource;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.Liquibase;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.report.DiffToReport;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.structure.core.Column;
import liquibase.structure.core.Data;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Sequence;
import liquibase.structure.core.StoredProcedure;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;
import liquibase.structure.core.View;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.postgresql.jdbc2.optional.SimpleDataSource;
import org.savantbuild.domain.Project;
import org.savantbuild.io.FileTools;
import org.savantbuild.output.Output;
import org.savantbuild.parser.groovy.GroovyTools;
import org.savantbuild.plugin.database.DatabaseSettings;
import org.savantbuild.plugin.groovy.BaseGroovyPlugin;
import org.savantbuild.runtime.RuntimeConfiguration;

public class DatabasePlugin
extends BaseGroovyPlugin {
    private DatabaseSettings settings;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public DatabasePlugin(Project project, RuntimeConfiguration runtimeConfiguration, Output output) {
        super(project, runtimeConfiguration, output);
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, DatabaseSettings.class, project);
        this.settings = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    public DiffResult compare(Map<String, Object> attributes) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasAttributes", 0, GroovyTools.class, attributes, "left", "right")) == false) {
            IndyInterface.bootstrap("invoke", "fail", 2, this, IndyInterface.bootstrap("invoke", "plus", 0, "You must specify the names of the databases to compare like this:\n\n", "  database.compare(left: \"database1\", right: \"database2\")"));
        }
        CallSite leftDatabaseName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, attributes, "left")));
        CallSite rightDatabaseName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, attributes, "right")));
        IndyInterface.bootstrap("invoke", "infoln", 0, IndyInterface.bootstrap("getProperty", "output", 12, this), new GStringImpl(new Object[]{leftDatabaseName, rightDatabaseName}, new String[]{"Comparing database [", "] to [", "]"}));
        CallSite leftDatabase = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "makeLiquibaseDatabase", 2, this, leftDatabaseName));
        CallSite rightDatabase = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "makeLiquibaseDatabase", 2, this, rightDatabaseName));
        CallSite databaseChangeLog = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DatabaseChangeLog.class));
        CallSite liquibase = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Liquibase.class, databaseChangeLog, IndyInterface.bootstrap("init", "<init>", 0, ClassLoaderResourceAccessor.class), leftDatabase));
        CallSite compareControl = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, CompareControl.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{Column.class, Data.class, ForeignKey.class, Index.class, PrimaryKey.class, Schema.class, Sequence.class, StoredProcedure.class, Table.class, UniqueConstraint.class, View.class}), Set.class))), Set.class)));
        IndyInterface.bootstrap("invoke", "setDiffColumnOrder", 0, IndyInterface.bootstrap("invoke", "getConfiguration", 0, IndyInterface.bootstrap("invoke", "getInstance", 0, LiquibaseConfiguration.class), GlobalConfiguration.class), false);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "diff", 0, liquibase, leftDatabase, rightDatabase, compareControl));
    }

    public void ensureEqual(Map<String, Object> attributes) {
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "compare", 2, this, attributes));
        try {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "areEqual", 0, result)) == false) {
                CallSite baos = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ByteArrayOutputStream.class));
                IndyInterface.bootstrap("invoke", "print", 0, IndyInterface.bootstrap("init", "<init>", 0, DiffToReport.class, result, IndyInterface.bootstrap("init", "<init>", 0, PrintStream.class, baos)));
                IndyInterface.bootstrap("invoke", "fail", 2, this, "Database are not equal. Errors are:\n\n[%s]", IndyInterface.bootstrap("invoke", "toString", 0, baos, "UTF-8"));
            }
        }
        finally {
            IndyInterface.bootstrap("invoke", "close", 0, IndyInterface.bootstrap("invoke", "getDatabase", 0, IndyInterface.bootstrap("invoke", "getReferenceSnapshot", 0, result)));
            IndyInterface.bootstrap("invoke", "close", 0, IndyInterface.bootstrap("invoke", "getDatabase", 0, IndyInterface.bootstrap("invoke", "getComparisonSnapshot", 0, result)));
        }
    }

    public void createDatabase() {
        IndyInterface.bootstrap("invoke", "infoln", 0, IndyInterface.bootstrap("getProperty", "output", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.settings)}, new String[]{"Creating database [", "]"}));
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "type", 4, this.settings)), (Object)"mysql")) {
            CallSite createUsername = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "createUsername", 4, this.settings)) != false ? IndyInterface.bootstrap("getProperty", "createUsername", 4, this.settings) : "root");
            IndyInterface.bootstrap("invoke", "execAndWait", 2, this, ScriptBytecodeAdapter.createList((Object[])new Object[]{"mysql", new GStringImpl(new Object[]{createUsername}, new String[]{"-u", ""}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "host", 4, this.settings)}, new String[]{"-h", ""}), "-v", IndyInterface.bootstrap("getProperty", "createArguments", 4, this.settings), "-e", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.settings)}, new String[]{"DROP DATABASE IF EXISTS ", ""})}));
            IndyInterface.bootstrap("invoke", "execAndWait", 2, this, ScriptBytecodeAdapter.createList((Object[])new Object[]{"mysql", new GStringImpl(new Object[]{createUsername}, new String[]{"-u", ""}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "host", 4, this.settings)}, new String[]{"-h", ""}), "-v", IndyInterface.bootstrap("getProperty", "createArguments", 4, this.settings), "-e", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.settings), IndyInterface.bootstrap("getProperty", "createSuffix", 4, this.settings)}, new String[]{"CREATE DATABASE ", " ", ""})}));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "grantUsername", 4, this.settings)) != false) {
                IndyInterface.bootstrap("invoke", "infoln", 0, IndyInterface.bootstrap("getProperty", "output", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "grantUsername", 4, this.settings)}, new String[]{"Granting privileges to [", "]"}));
                IndyInterface.bootstrap("invoke", "execAndWait", 2, this, ScriptBytecodeAdapter.createList((Object[])new Object[]{"mysql", new GStringImpl(new Object[]{createUsername}, new String[]{"-u", ""}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "host", 4, this.settings)}, new String[]{"-h", ""}), "-v", IndyInterface.bootstrap("getProperty", "createArguments", 4, this.settings), "-e", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "grantUsername", 4, this.settings), IndyInterface.bootstrap("getProperty", "grantPassword", 4, this.settings)}, new String[]{"CREATE USER '", "'@'%' IDENTIFIED BY '", "'"})}), true);
                IndyInterface.bootstrap("invoke", "execAndWait", 2, this, ScriptBytecodeAdapter.createList((Object[])new Object[]{"mysql", new GStringImpl(new Object[]{createUsername}, new String[]{"-u", ""}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "host", 4, this.settings)}, new String[]{"-h", ""}), "-v", IndyInterface.bootstrap("getProperty", "createArguments", 4, this.settings), "-e", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.settings), IndyInterface.bootstrap("getProperty", "grantUsername", 4, this.settings)}, new String[]{"GRANT ALL PRIVILEGES ON ", ".* TO '", "'@'%'"})}));
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "type", 4, this.settings)), (Object)"postgresql")) {
            CallSite createUsername = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "createUsername", 4, this.settings)) != false ? IndyInterface.bootstrap("getProperty", "createUsername", 4, this.settings) : "postgres");
            IndyInterface.bootstrap("invoke", "execAndWait", 2, this, ScriptBytecodeAdapter.createList((Object[])new Object[]{"psql", new GStringImpl(new Object[]{createUsername}, new String[]{"-U", ""}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "host", 4, this.settings)}, new String[]{"-h", ""}), IndyInterface.bootstrap("getProperty", "createArguments", 4, this.settings), "-c", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.settings)}, new String[]{"DROP DATABASE IF EXISTS ", ""})}));
            IndyInterface.bootstrap("invoke", "execAndWait", 2, this, ScriptBytecodeAdapter.createList((Object[])new Object[]{"psql", new GStringImpl(new Object[]{createUsername}, new String[]{"-U", ""}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "host", 4, this.settings)}, new String[]{"-h", ""}), IndyInterface.bootstrap("getProperty", "createArguments", 4, this.settings), "-c", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.settings), IndyInterface.bootstrap("getProperty", "createSuffix", 4, this.settings)}, new String[]{"CREATE DATABASE ", " ", ""})}));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "grantUsername", 4, this.settings)) != false) {
                IndyInterface.bootstrap("invoke", "infoln", 0, IndyInterface.bootstrap("getProperty", "output", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "grantUsername", 4, this.settings)}, new String[]{"Granting privileges to [", "]"}));
                IndyInterface.bootstrap("invoke", "execAndWait", 2, this, ScriptBytecodeAdapter.createList((Object[])new Object[]{"psql", new GStringImpl(new Object[]{createUsername}, new String[]{"-U", ""}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "host", 4, this.settings)}, new String[]{"-h", ""}), IndyInterface.bootstrap("getProperty", "createArguments", 4, this.settings), "-c", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "grantUsername", 4, this.settings), IndyInterface.bootstrap("getProperty", "grantPassword", 4, this.settings)}, new String[]{"CREATE ROLE ", " login superuser password '", "'"})}), true);
                IndyInterface.bootstrap("invoke", "execAndWait", 2, this, ScriptBytecodeAdapter.createList((Object[])new Object[]{"psql", new GStringImpl(new Object[]{createUsername}, new String[]{"-U", ""}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "host", 4, this.settings)}, new String[]{"-h", ""}), IndyInterface.bootstrap("getProperty", "createArguments", 4, this.settings), "-c", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.settings), IndyInterface.bootstrap("getProperty", "grantUsername", 4, this.settings)}, new String[]{"GRANT ALL PRIVILEGES ON DATABASE ", " TO ", ""})}));
                IndyInterface.bootstrap("invoke", "execAndWait", 2, this, ScriptBytecodeAdapter.createList((Object[])new Object[]{"psql", new GStringImpl(new Object[]{createUsername}, new String[]{"-U", ""}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "host", 4, this.settings)}, new String[]{"-h", ""}), IndyInterface.bootstrap("getProperty", "createArguments", 4, this.settings), "-c", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, this.settings), IndyInterface.bootstrap("getProperty", "grantUsername", 4, this.settings)}, new String[]{"ALTER DATABASE ", " OWNER TO ", ""})}));
            }
        } else {
            IndyInterface.bootstrap("invoke", "fail", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "type", 4, this.settings)}, new String[]{"Unsupported database type [", "]"}));
        }
    }

    public void createMainDatabase() {
        CallSite callSite = IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "project", 12, this)), "-", "_"), "\\.", "_");
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, DatabasePlugin.class, (GroovyObject)this.settings, (String)"name");
        IndyInterface.bootstrap("invoke", "createDatabase", 2, this);
    }

    public void createTestDatabase() {
        CallSite callSite = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("invoke", "replaceAll", 0, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "project", 12, this)), "-", "_"), "\\.", "_"), "_test");
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, DatabasePlugin.class, (GroovyObject)this.settings, (String)"name");
        IndyInterface.bootstrap("invoke", "createDatabase", 2, this);
    }

    public void execute(Map<String, Object> attributes) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasAttributes", 0, GroovyTools.class, attributes, "file")) == false) {
            IndyInterface.bootstrap("invoke", "fail", 2, this, "You must specify the name of the SQL file to execute using the file attribute like this:\n\n  database.execute(file: \"foo.sql\")");
        }
        IndyInterface.bootstrap("invoke", "infoln", 0, IndyInterface.bootstrap("getProperty", "output", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, attributes, "file")}, new String[]{"Executing SQL script [", "]"}));
        CallSite file = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toPath", 0, FileTools.class, IndyInterface.bootstrap("invoke", "getAt", 0, attributes, "file")));
        CallSite resolvedFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolve", 0, IndyInterface.bootstrap("getProperty", "directory", 0, IndyInterface.bootstrap("getProperty", "project", 12, this)), file));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isRegularFile", 0, Files.class, resolvedFile)) == false || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isReadable", 0, Files.class, resolvedFile)) == false) {
            IndyInterface.bootstrap("invoke", "fail", 2, this, new GStringImpl(new Object[]{resolvedFile}, new String[]{"Invalid SQL script to execute [", "]"}));
        }
        CallSite script = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, String.class, IndyInterface.bootstrap("invoke", "readAllBytes", 0, Files.class, resolvedFile), "UTF-8"));
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "type", 4, this.settings)), (Object)"mysql")) {
            IndyInterface.bootstrap("invoke", "execAndWait", 2, this, ScriptBytecodeAdapter.createList((Object[])new Object[]{"mysql", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "executeUsername", 4, this.settings)}, new String[]{"-u", ""}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "host", 4, this.settings)}, new String[]{"-h", ""}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "executePassword", 4, this.settings)}, new String[]{"-p", ""}), "-v", IndyInterface.bootstrap("getProperty", "executeArguments", 4, this.settings), IndyInterface.bootstrap("getProperty", "name", 4, this.settings)}), script, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, attributes, "file")));
        } else if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "type", 4, this.settings)), (Object)"postgresql")) {
            IndyInterface.bootstrap("invoke", "execAndWait", 2, this, ScriptBytecodeAdapter.createList((Object[])new Object[]{"psql", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "executeUsername", 4, this.settings)}, new String[]{"-U", ""}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "host", 4, this.settings)}, new String[]{"-h", ""}), IndyInterface.bootstrap("getProperty", "executeArguments", 4, this.settings), IndyInterface.bootstrap("getProperty", "name", 4, this.settings)}), script, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, attributes, "file")));
        } else {
            IndyInterface.bootstrap("invoke", "fail", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "type", 4, this.settings)}, new String[]{"Unsupported database type [", "]"}));
        }
    }

    private Database makeLiquibaseDatabase(String name) {
        CallSite database = null;
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 4, this.settings), (Object)"mysql")) {
            CallSite ds = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, MysqlDataSource.class));
            IndyInterface.bootstrap("invoke", "setURL", 0, ds, new GStringImpl(new Object[]{name}, new String[]{"jdbc:mysql://localhost:3306/", "?serverTimezone=UTC&useSSL=false"}));
            CallSite c = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getConnection", 0, ds, IndyInterface.bootstrap("getProperty", "compareUsername", 4, this.settings), IndyInterface.bootstrap("getProperty", "comparePassword", 4, this.settings)));
            database = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, MySQLDatabase.class));
            IndyInterface.bootstrap("invoke", "setConnection", 0, database, IndyInterface.bootstrap("init", "<init>", 0, JdbcConnection.class, c));
        } else {
            CallSite ds = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, SimpleDataSource.class));
            IndyInterface.bootstrap("invoke", "setUrl", 0, ds, new GStringImpl(new Object[]{name}, new String[]{"jdbc:postgresql://localhost:5432/", ""}));
            IndyInterface.bootstrap("invoke", "setUser", 0, ds, IndyInterface.bootstrap("getProperty", "compareUsername", 4, this.settings));
            IndyInterface.bootstrap("invoke", "setPassword", 0, ds, IndyInterface.bootstrap("getProperty", "comparePassword", 4, this.settings));
            database = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, PostgresDatabase.class));
            IndyInterface.bootstrap("invoke", "setConnection", 0, database, IndyInterface.bootstrap("init", "<init>", 0, JdbcConnection.class, IndyInterface.bootstrap("invoke", "getConnection", 0, ds)));
        }
        return database;
    }

    private void execAndWait(List<String> command, boolean ignoreFailure) {
        public final class _execAndWait_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _execAndWait_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("invoke", "trim", 0, it));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _execAndWait_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "removeAll", 0, command, new _execAndWait_closure1((Object)this, (Object)this));
        IndyInterface.bootstrap("invoke", "debugln", 0, IndyInterface.bootstrap("getProperty", "output", 12, this), "Running [%s]", IndyInterface.bootstrap("invoke", "join", 0, command, " "));
        CallSite process = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execute", 0, command));
        CallSite out = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class));
        CallSite err = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class));
        IndyInterface.bootstrap("invoke", "consumeProcessOutput", 0, process, out, err);
        int code = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "waitFor", 0, process));
        IndyInterface.bootstrap("invoke", "debugln", 0, IndyInterface.bootstrap("getProperty", "output", 12, this), IndyInterface.bootstrap("invoke", "toString", 0, out));
        IndyInterface.bootstrap("invoke", "debugln", 0, IndyInterface.bootstrap("getProperty", "output", 12, this), IndyInterface.bootstrap("invoke", "toString", 0, err));
        if (code != 0 && !ignoreFailure) {
            IndyInterface.bootstrap("invoke", "fail", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, command, " ")}, new String[]{"Command [", "] failed. Turn on debugging to see the error message from the database."}));
        }
    }

    private void execAndWait(List<String> command, String input, String fileName) {
        Reference input2 = new Reference((Object)input);
        public final class _execAndWait_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _execAndWait_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("invoke", "trim", 0, it));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _execAndWait_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "removeAll", 0, command, new _execAndWait_closure2((Object)this, (Object)this));
        IndyInterface.bootstrap("invoke", "debugln", 0, IndyInterface.bootstrap("getProperty", "output", 12, this), "Running [%s]", IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "join", 0, command, " "), new GStringImpl(new Object[]{fileName}, new String[]{" < ", ""})));
        CallSite process = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execute", 0, command));
        CallSite out = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class));
        CallSite err = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class));
        IndyInterface.bootstrap("invoke", "consumeProcessOutput", 0, process, out, err);
        public final class _execAndWait_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference input;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _execAndWait_closure3(Object _outerInstance, Object _thisObject, Reference input) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.input = reference = input;
            }

            public Object doCall(Object writer) {
                return IndyInterface.bootstrap("invoke", "leftShift", 0, writer, IndyInterface.bootstrap("cast", "()", 0, this.input.get()));
            }

            @Generated
            public String getInput() {
                return IndyInterface.bootstrap("cast", "()", 0, this.input.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _execAndWait_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "withWriter", 0, process, new _execAndWait_closure3((Object)this, (Object)this, input2));
        int code = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "waitFor", 0, process));
        IndyInterface.bootstrap("invoke", "debugln", 0, IndyInterface.bootstrap("getProperty", "output", 12, this), IndyInterface.bootstrap("invoke", "toString", 0, out));
        IndyInterface.bootstrap("invoke", "debugln", 0, IndyInterface.bootstrap("getProperty", "output", 12, this), IndyInterface.bootstrap("invoke", "toString", 0, err));
        if (code != 0) {
            IndyInterface.bootstrap("invoke", "fail", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, command, " "), fileName}, new String[]{"Command [", " < ", "] failed. Turn on debugging to see the error message from the database."}));
        }
    }

    @Generated
    private void execAndWait(List<String> command) {
        this.execAndWait(command, false);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != DatabasePlugin.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public DatabaseSettings getSettings() {
        return this.settings;
    }

    @Generated
    public void setSettings(DatabaseSettings databaseSettings) {
        this.settings = databaseSettings;
    }
}

