/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import org.primeframework.mvc.util.Classpath;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ClasspathTest {
    @Test
    public void clean() throws Exception {
        this.assertCleanedPath("src/test/resources/jars/test+foo.jar");
        this.assertCleanedPath("src/test/resources/jars/test-foo-{integration}.jar");
    }

    private void assertCleanedPath(String string) throws NoSuchMethodException, IOException, InvocationTargetException, IllegalAccessException, URISyntaxException {
        URL[] uRLArray = new URL[]{new File(string).toURI().toURL()};
        URLClassLoader uRLClassLoader = URLClassLoader.newInstance(uRLArray, Thread.currentThread().getContextClassLoader());
        Classpath.ClasspathBuilder classpathBuilder = new Classpath.ClasspathBuilder((ClassLoader)uRLClassLoader);
        Method method = Classpath.ClasspathBuilder.class.getDeclaredMethod("clean", URL.class);
        method.setAccessible(true);
        String string2 = (String)method.invoke((Object)classpathBuilder, uRLArray[0]);
        Assert.assertEquals((String)string2, (String)new File(string).getAbsoluteFile().toString());
    }
}

