/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.Map;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.cors.CORSConfigurationProvider;
import org.primeframework.mvc.cors.NoCORSConfigurationProvider;
import org.primeframework.mvc.guice.GuiceBootstrap;
import org.primeframework.mvc.guice.MVCModule;
import org.primeframework.mvc.parameter.convert.DefaultConverterProvider;
import org.primeframework.mvc.parameter.convert.GlobalConverter;
import org.primeframework.mvc.parameter.convert.converters.BooleanConverter;
import org.primeframework.mvc.parameter.convert.converters.CharacterConverter;
import org.primeframework.mvc.parameter.convert.converters.NumberConverter;
import org.primeframework.mvc.parameter.convert.converters.StringConverter;
import org.primeframework.mvc.security.MockUserLoginSecurityContext;
import org.primeframework.mvc.security.UserLoginSecurityContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultConverterProviderTest
extends PrimeBaseTest {
    @Test
    public void lookups() {
        Injector injector = GuiceBootstrap.initialize((Module[])new Module[]{new MVCModule(this){

            protected void configure() {
                super.configure();
                this.install((Module)new PrimeBaseTest.TestMVCConfigurationModule());
                this.bind(UserLoginSecurityContext.class).to(MockUserLoginSecurityContext.class);
                this.bind(CORSConfigurationProvider.class).to(NoCORSConfigurationProvider.class);
            }
        }});
        DefaultConverterProvider defaultConverterProvider = new DefaultConverterProvider(injector, (Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<Class<?>, GlobalConverter>>(this){})));
        GlobalConverter globalConverter = defaultConverterProvider.lookup(Character.class);
        Assert.assertSame(CharacterConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Character.TYPE);
        Assert.assertSame(CharacterConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Character[].class);
        Assert.assertSame(CharacterConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(char[].class);
        Assert.assertSame(CharacterConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Byte.class);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Byte.TYPE);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Byte[].class);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(byte[].class);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Short.class);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Short.TYPE);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Short[].class);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(short[].class);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Integer.class);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Integer.TYPE);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Integer[].class);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(int[].class);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Long.class);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Long.TYPE);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Long[].class);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(long[].class);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Float.class);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Float.TYPE);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Float[].class);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(float[].class);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Double.class);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Double.TYPE);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Double[].class);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(double[].class);
        Assert.assertSame(NumberConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Boolean.class);
        Assert.assertSame(BooleanConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Boolean.TYPE);
        Assert.assertSame(BooleanConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(Boolean[].class);
        Assert.assertSame(BooleanConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(boolean[].class);
        Assert.assertSame(BooleanConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(String.class);
        Assert.assertSame(StringConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(String[].class);
        Assert.assertSame(StringConverter.class, (Object)globalConverter.getClass());
        globalConverter = defaultConverterProvider.lookup(this.getClass());
        Assert.assertNull((Object)globalConverter);
    }
}

