/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Injector;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.FileInfo;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.primeframework.mock.MockUserAgent;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.http.FormBodyPublisher;
import org.primeframework.mvc.http.HTTPObjectsHolder;
import org.primeframework.mvc.http.MultipartBodyHandler;
import org.primeframework.mvc.http.MultipartFileUpload;
import org.primeframework.mvc.message.TestMessageObserver;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.security.csrf.CSRFProvider;
import org.primeframework.mvc.test.BodyTools;
import org.primeframework.mvc.test.HTTPResponseWrapper;
import org.primeframework.mvc.test.JSONBuilder;
import org.primeframework.mvc.test.RequestResult;
import org.primeframework.mvc.util.CookieTools;
import org.primeframework.mvc.util.QueryStringBuilder;
import org.primeframework.mvc.util.QueryStringTools;
import org.primeframework.mvc.util.URITools;

public class RequestBuilder {
    public static HttpClient HttpClientInstance = RequestBuilder.newHttpClient();
    public final Injector injector;
    public final TestMessageObserver messageObserver;
    public final int port;
    public final HTTPRequest request;
    public final Map<String, List<String>> requestBodyParameters = new LinkedHashMap<String, List<String>>();
    public final MockUserAgent userAgent;
    public boolean useTLS;
    private byte[] body;
    @Inject(optional=true)
    private HTTPRequestConsumer httpRequestConsumer;

    public RequestBuilder(String string, Injector injector, MockUserAgent mockUserAgent, TestMessageObserver testMessageObserver, int n) {
        this.injector = injector;
        this.userAgent = mockUserAgent;
        this.messageObserver = testMessageObserver;
        this.request = (HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.setPath(string));
        this.port = n;
        injector.injectMembers((Object)this);
    }

    public static HttpClient newHttpClient() {
        return HttpClient.newBuilder().connectTimeout(Duration.ofMillis(250L)).executor(Executors.newVirtualThreadPerTaskExecutor()).followRedirects(HttpClient.Redirect.NEVER).build();
    }

    public static void resetHttpClientInstance() {
        HttpClientInstance = RequestBuilder.newHttpClient();
    }

    public RequestBuilder build(Consumer<RequestBuilder> consumer) {
        consumer.accept(this);
        return this;
    }

    public RequestResult connect() {
        this.request.setMethod(HTTPMethod.CONNECT);
        HTTPResponseWrapper hTTPResponseWrapper = this.run();
        return new RequestResult(this.injector, this.request, hTTPResponseWrapper, this.userAgent, this.messageObserver, this.port);
    }

    public RequestResult delete() {
        this.request.setMethod(HTTPMethod.DELETE);
        HTTPResponseWrapper hTTPResponseWrapper = this.run();
        return new RequestResult(this.injector, this.request, hTTPResponseWrapper, this.userAgent, this.messageObserver, this.port);
    }

    public RequestResult get() {
        this.request.setMethod(HTTPMethod.GET);
        HTTPResponseWrapper hTTPResponseWrapper = this.run();
        return new RequestResult(this.injector, this.request, hTTPResponseWrapper, this.userAgent, this.messageObserver, this.port);
    }

    public HTTPRequest getRequest() {
        return this.request;
    }

    public RequestResult head() {
        this.request.setMethod(HTTPMethod.HEAD);
        HTTPResponseWrapper hTTPResponseWrapper = this.run();
        return new RequestResult(this.injector, this.request, hTTPResponseWrapper, this.userAgent, this.messageObserver, this.port);
    }

    public RequestBuilder ifElse(boolean bl, RequestResult.ThrowingConsumer<RequestBuilder> throwingConsumer, RequestResult.ThrowingConsumer<RequestBuilder> throwingConsumer2) throws Exception {
        if (bl) {
            throwingConsumer.accept(this);
        } else {
            throwingConsumer2.accept(this);
        }
        return this;
    }

    public RequestBuilder ifFalse(boolean bl, RequestResult.ThrowingConsumer<RequestBuilder> throwingConsumer) throws Exception {
        return this.ifTrue(!bl, throwingConsumer);
    }

    public RequestBuilder ifTrue(boolean bl, RequestResult.ThrowingConsumer<RequestBuilder> throwingConsumer) throws Exception {
        if (bl) {
            throwingConsumer.accept(this);
        }
        return this;
    }

    public RequestResult method(HTTPMethod hTTPMethod) {
        this.request.setMethod(hTTPMethod);
        HTTPResponseWrapper hTTPResponseWrapper = this.run();
        return new RequestResult(this.injector, this.request, hTTPResponseWrapper, this.userAgent, this.messageObserver, this.port);
    }

    public RequestResult method(String string) {
        return this.method(HTTPMethod.of((String)string));
    }

    public RequestResult options() {
        this.request.setMethod(HTTPMethod.OPTIONS);
        HTTPResponseWrapper hTTPResponseWrapper = this.run();
        return new RequestResult(this.injector, this.request, hTTPResponseWrapper, this.userAgent, this.messageObserver, this.port);
    }

    public RequestResult patch() {
        this.request.setMethod(HTTPMethod.PATCH);
        HTTPResponseWrapper hTTPResponseWrapper = this.run();
        return new RequestResult(this.injector, this.request, hTTPResponseWrapper, this.userAgent, this.messageObserver, this.port);
    }

    public RequestResult post() {
        this.request.setMethod(HTTPMethod.POST);
        HTTPResponseWrapper hTTPResponseWrapper = this.run();
        return new RequestResult(this.injector, this.request, hTTPResponseWrapper, this.userAgent, this.messageObserver, this.port);
    }

    public RequestResult put() {
        this.request.setMethod(HTTPMethod.PUT);
        HTTPResponseWrapper hTTPResponseWrapper = this.run();
        return new RequestResult(this.injector, this.request, hTTPResponseWrapper, this.userAgent, this.messageObserver, this.port);
    }

    public RequestBuilder setup(Consumer<HTTPRequest> consumer) {
        consumer.accept(this.request);
        return this;
    }

    public RequestResult trace() {
        this.request.setMethod(HTTPMethod.TRACE);
        HTTPResponseWrapper hTTPResponseWrapper = this.run();
        return new RequestResult(this.injector, this.request, hTTPResponseWrapper, this.userAgent, this.messageObserver, this.port);
    }

    public RequestBuilder usingHTTPS() {
        throw new IllegalStateException("This handling is not implemented yet");
    }

    public RequestBuilder withAuthorizationHeader(Object object) {
        this.request.setHeader("Authorization", object.toString());
        return this;
    }

    public RequestBuilder withBasicAuthorizationHeader(String string, String string2) {
        String string3 = string + (String)(string2 != null ? ":" + string2 : "");
        this.request.setHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString(string3.getBytes()));
        return this;
    }

    public RequestBuilder withBody(byte[] byArray) {
        this.body = byArray;
        return this;
    }

    public RequestBuilder withBody(String string) {
        return this.withBody(string.getBytes(StandardCharsets.UTF_8));
    }

    public RequestBuilder withBodyFile(Path path, Object ... objectArray) throws IOException {
        return this.withBody(BodyTools.processTemplate(path, objectArray));
    }

    public RequestBuilder withBodyFileRaw(Path path) throws IOException {
        return this.withBody(Files.readAllBytes(path));
    }

    public RequestBuilder withCSRFToken(String string) {
        String string2 = ((CSRFProvider)this.injector.getInstance(CSRFProvider.class)).getParameterName();
        this.request.addURLParameter(string2, string);
        return this;
    }

    public RequestBuilder withCheckbox(String string, String string2, String string3, boolean bl) {
        if (bl) {
            this.withParameter(string, string2);
        }
        this.withParameter("__cb_" + string, string3);
        return this;
    }

    public RequestBuilder withContentType(String string) {
        this.request.setContentType(string);
        return this;
    }

    public RequestBuilder withContextPath(String string) {
        this.request.setContextPath(string);
        return this;
    }

    public RequestBuilder withCookie(String string, String string2, boolean bl, boolean bl2) throws Exception {
        if (string != null) {
            Cookie cookie = (bl || bl2) && string2 != null ? new Cookie(string, CookieTools.toCookie((byte[])string2.getBytes(StandardCharsets.UTF_8), (boolean)bl, (boolean)bl2, (Encryptor)((Encryptor)this.injector.getInstance(Encryptor.class)))) : new Cookie(string, string2);
            this.request.addCookies(new Cookie[]{cookie});
        }
        return this;
    }

    public RequestBuilder withCookie(String string, String string2) throws Exception {
        return this.withCookie(string, string2, false, false);
    }

    public RequestBuilder withCookie(Cookie cookie) {
        if (cookie != null) {
            this.request.addCookies(new Cookie[]{cookie});
        }
        return this;
    }

    public RequestBuilder withEncoding(Charset charset) {
        this.request.setCharacterEncoding(charset);
        return this;
    }

    public RequestBuilder withEncryptedCookie(String string, String string2) throws Exception {
        return this.withCookie(string, string2, false, true);
    }

    public RequestBuilder withFile(String string, Path path, String string2) {
        this.request.getFiles().add(new FileInfo(path, null, string, string2, StandardCharsets.UTF_8));
        return this;
    }

    public RequestBuilder withHeader(String string, Object object) {
        this.request.addHeader(string, object.toString());
        return this;
    }

    public RequestBuilder withJSON(Object object) throws JsonProcessingException {
        return this.withJSON("application/json", object);
    }

    public RequestBuilder withJSON(String string, Object object) throws JsonProcessingException {
        ObjectMapper objectMapper = (ObjectMapper)this.injector.getInstance(ObjectMapper.class);
        byte[] byArray = objectMapper.writeValueAsBytes(object);
        return this.withContentType(string).withBody(byArray);
    }

    public RequestBuilder withJSON(String string) {
        return this.withJSON("application/json", string);
    }

    public RequestBuilder withJSON(String string, String string2) {
        return this.withContentType(string).withBody(string2);
    }

    public RequestBuilder withJSONBuilder(RequestResult.ThrowingConsumer<JSONBuilder> throwingConsumer) throws Exception {
        return this.withJSONBuilder("application/json", throwingConsumer);
    }

    public RequestBuilder withJSONBuilder(String string, RequestResult.ThrowingConsumer<JSONBuilder> throwingConsumer) throws Exception {
        ObjectMapper objectMapper = (ObjectMapper)this.injector.getInstance(ObjectMapper.class);
        JSONBuilder jSONBuilder = new JSONBuilder(objectMapper);
        throwingConsumer.accept(jSONBuilder);
        this.withJSON(string, jSONBuilder.build());
        return this;
    }

    public RequestBuilder withJSONFile(Path path, Object ... objectArray) throws IOException {
        return this.withJSONFile("application/json", path, objectArray);
    }

    public RequestBuilder withJSONFile(String string, Path path, Object ... objectArray) throws IOException {
        return this.withContentType(string).withBodyFile(path, objectArray);
    }

    public RequestBuilder withLocale(Locale locale) {
        this.request.addLocales(new Locale[]{locale});
        return this;
    }

    public RequestBuilder withParameter(String string2, Object object) {
        this.requestBodyParameters.computeIfAbsent(string2, string -> new ArrayList()).add(object != null ? object.toString() : null);
        return this;
    }

    public RequestBuilder withParameters(String string2, Collection<?> collection) {
        this.requestBodyParameters.computeIfAbsent(string2, string -> new ArrayList()).addAll(collection.stream().map(Object::toString).toList());
        return this;
    }

    public RequestBuilder withQueryString(String string) {
        QueryStringTools.parseQueryString((String)string).forEach(this::withURLParameters);
        return this;
    }

    public RequestBuilder withRadio(String string, String string2, String string3, boolean bl) {
        if (bl) {
            this.setRequestBodyParameter(string, string2);
        }
        this.setRequestBodyParameter("__rb_" + string, string3);
        return this;
    }

    public RequestBuilder withSingleHeader(String string, String string2) {
        this.request.setHeader(string, string2);
        return this;
    }

    public RequestBuilder withURLParameter(String string, Object object) {
        this.request.addURLParameter(string, object.toString());
        return this;
    }

    public RequestBuilder withURLParameters(String string, Collection<?> collection) {
        this.request.addURLParameters(string, (Collection)collection.stream().map(Object::toString).collect(Collectors.toList()));
        return this;
    }

    public RequestBuilder withURLSegment(Object object) {
        if (object != null) {
            Object object2 = this.request.getPath();
            if (((String)object2).charAt(((String)object2).length() - 1) != '/') {
                object2 = (String)object2 + "/";
            }
            this.request.setPath((String)object2 + URITools.encodeURIPathSegment((Object)object));
        }
        return this;
    }

    @Deprecated
    public RequestBuilder withUrlSegment(Object object) {
        return this.withURLSegment(object);
    }

    HTTPResponseWrapper run() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        HTTPObjectsHolder.clearRequest();
        HTTPObjectsHolder.setRequest((HTTPRequest)this.request);
        HTTPObjectsHolder.clearResponse();
        HTTPObjectsHolder.setResponse((HTTPResponse)new HTTPResponse());
        String string2 = UUID.randomUUID().toString();
        this.messageObserver.setMessageStoreId(string2);
        this.request.addHeader("X-Observer-MessageStoreId", string2);
        this.userAgent.addCookies(this.request.getCookies());
        this.request.getCookies().clear();
        this.request.addCookies(this.userAgent.getCookies(this.request));
        String string3 = this.useTLS ? "https://" : "http://";
        URI uRI = URI.create(string3 + "localhost:" + this.port + this.request.getPath());
        if (this.request.getHeader("Referer") == null) {
            this.request.setHeader("Referer", uRI.toString());
        }
        this.request.setPort(this.port);
        this.request.setHost(uRI.getHost());
        this.request.setScheme(uRI.getScheme());
        if (this.request.getMethod() == HTTPMethod.POST && (object6 = (MVCConfiguration)this.injector.getInstance(MVCConfiguration.class)).csrfEnabled() && (object5 = (CSRFProvider)this.injector.getInstance(CSRFProvider.class)).getTokenFromRequest(this.request) == null && (object4 = object5.getToken(this.request)) != null) {
            object3 = object5.getParameterName();
            this.requestBodyParameters.put((String)object3, List.of(object4));
        }
        if (this.httpRequestConsumer != null) {
            this.httpRequestConsumer.accept(this.request);
        }
        object6 = this.request.getLocales();
        object5 = this.request.getContentType();
        object4 = this.request.getCharacterEncoding();
        object3 = this.request.getMethod();
        Map map = this.request.getParameters();
        List list = this.request.getFiles();
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.noBody();
        ByteArrayInputStream byteArrayInputStream = null;
        if (list != null && !list.isEmpty()) {
            object2 = list.stream().map(fileInfo -> new MultipartFileUpload(fileInfo.contentType, fileInfo.file, fileInfo.fileName, fileInfo.name)).collect(Collectors.toList());
            object = new MultipartBodyHandler(new MultipartBodyHandler.Multiparts((List<MultipartFileUpload>)object2, this.requestBodyParameters));
            bodyPublisher = HttpRequest.BodyPublishers.ofByteArray(((MultipartBodyHandler)object).getBody());
            if (object5 == null) {
                object5 = "multipart/form-data; boundary=" + ((MultipartBodyHandler)object).boundary;
            }
            byteArrayInputStream = new ByteArrayInputStream(((MultipartBodyHandler)object).getBody());
        } else if (this.body != null) {
            bodyPublisher = HttpRequest.BodyPublishers.ofByteArray(this.body);
            byteArrayInputStream = new ByteArrayInputStream(this.body);
        } else if (!this.requestBodyParameters.isEmpty()) {
            object2 = new FormBodyPublisher(this.requestBodyParameters).getBody();
            bodyPublisher = HttpRequest.BodyPublishers.ofByteArray((byte[])object2);
            if (object5 == null) {
                object5 = "application/x-www-form-urlencoded";
            }
            byteArrayInputStream = new ByteArrayInputStream((byte[])object2);
        }
        if (byteArrayInputStream != null) {
            this.request.setInputStream((InputStream)byteArrayInputStream);
        }
        object2 = HttpRequest.newBuilder().method(this.request.getMethod().name(), bodyPublisher);
        if (object6.isEmpty()) {
            object6 = List.of(Locale.getDefault());
        }
        object2.setHeader("Accept-Language", object6.stream().map(Locale::toLanguageTag).collect(Collectors.joining(", ")));
        if (object5 != null) {
            object2.setHeader("Content-Type", (String)object5 + (String)(object4 != null ? "; charset=" + String.valueOf(object4) : ""));
            this.request.setContentType((String)object5);
        }
        this.request.getHeaders().forEach((arg_0, arg_1) -> RequestBuilder.lambda$run$5((HttpRequest.Builder)object2, arg_0, arg_1));
        if (this.request.getHeaders().keySet().stream().noneMatch(string -> string.equalsIgnoreCase("Cookie")) && !this.request.getCookies().isEmpty()) {
            object = this.request.getCookies().stream().map(Cookie::toRequestHeader).collect(Collectors.joining("; "));
            object2.setHeader("Cookie", (String)object);
        }
        if (this.request.getHeaders().keySet().stream().noneMatch(string -> string.equalsIgnoreCase("User-Agent"))) {
            object2.setHeader("User-Agent", "Java HttpClient");
        }
        object = QueryStringBuilder.builder();
        map.forEach((arg_0, arg_1) -> RequestBuilder.lambda$run$9((QueryStringBuilder)object, arg_0, arg_1));
        URI uRI2 = map.isEmpty() ? uRI : URI.create(String.valueOf(uRI) + "?" + object.build());
        object2.uri(uRI2);
        HTTPResponseWrapper hTTPResponseWrapper = new HTTPResponseWrapper();
        try {
            hTTPResponseWrapper.response = HttpClientInstance.send(object2.build(), HttpResponse.BodyHandlers.ofByteArray());
        }
        catch (Exception exception) {
            hTTPResponseWrapper.exception = exception;
            hTTPResponseWrapper.init();
            return hTTPResponseWrapper;
        }
        this.userAgent.addCookies(this.getCookies(hTTPResponseWrapper.response).stream().map(cookie -> (Cookie)((Cookie)((Cookie)((Cookie)((Cookie)((Cookie)((Cookie)((Cookie)((Cookie)new Cookie().with(cookie2 -> {
            cookie2.domain = cookie.domain;
        })).with(cookie2 -> {
            cookie2.expires = cookie.expires;
        })).with(cookie2 -> {
            cookie2.httpOnly = cookie.httpOnly;
        })).with(cookie2 -> {
            cookie2.maxAge = cookie.maxAge;
        })).with(cookie2 -> {
            cookie2.name = cookie.name;
        })).with(cookie2 -> {
            cookie2.path = cookie.path;
        })).with(cookie2 -> {
            cookie2.sameSite = cookie.sameSite != null ? Cookie.SameSite.valueOf((String)cookie.sameSite.name()) : null;
        })).with(cookie2 -> {
            cookie2.secure = cookie.secure;
        })).with(cookie2 -> {
            cookie2.value = cookie.value;
        })).collect(Collectors.toList()));
        hTTPResponseWrapper.init();
        return hTTPResponseWrapper;
    }

    private List<Cookie> getCookies(HttpResponse<byte[]> httpResponse) {
        List<String> list = httpResponse.headers().allValues("Set-Cookie".toLowerCase());
        if (list != null && !list.isEmpty()) {
            return list.stream().map(Cookie::fromResponseHeader).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return List.of();
    }

    private void setRequestBodyParameter(String string, Object object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(object.toString());
        this.requestBodyParameters.put(string, arrayList);
    }

    private static /* synthetic */ void lambda$run$9(QueryStringBuilder queryStringBuilder, String string, List list) {
        list.forEach(string2 -> queryStringBuilder.with(string, string2));
    }

    private static /* synthetic */ void lambda$run$5(HttpRequest.Builder builder, String string, List list) {
        list.forEach(string2 -> builder.header(string, (String)string2));
    }

    public static interface HTTPRequestConsumer {
        public void accept(HTTPRequest var1);
    }
}

