/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.test;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.primeframework.mvc.test.JSONBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JSONBuilderTest {
    public Map<String, Object> json = Map.of("user", Map.of("email", "erlich@piedpiper.com", "mobilePhone", "555-555-5555", "nested", List.of(Map.of("key1", "value1"))));
    private JSONBuilder handler;
    private ObjectMapper objectMapper;
    private JsonNode root;

    @BeforeMethod
    public void beforeMethod() throws IOException {
        this.objectMapper = new ObjectMapper();
        this.root = this.objectMapper.readTree(this.objectMapper.writeValueAsBytes(this.json));
        this.handler = new JSONBuilder(this.root);
    }

    @Test
    public void test() throws Exception {
        Assert.assertTrue((boolean)this.handler.remove((String[])new String[]{"user.email"}).root.at("/user/email").isMissingNode(), (String)this.handler.root.toString());
        this.handler.add("hey!", "ho!");
        Assert.assertEquals((String)this.handler.root.at("/hey!").asText(), (String)"ho!");
        this.handler.add("user.email", "erlich@piedpiper.com");
        Assert.assertEquals((String)this.handler.root.at("/user/email").asText(), (String)"erlich@piedpiper.com");
        this.handler.add("user.favoriteNumber", 42);
        Assert.assertEquals((int)this.handler.root.at("/user/favoriteNumber").asInt(), (int)42);
        this.handler.add("user.active", true);
        Assert.assertTrue((boolean)this.handler.root.at("/user/active").asBoolean());
        this.handler.add("user.roles", List.of("admin", "user"));
        Assert.assertTrue((boolean)this.handler.root.at("/user/roles").isArray(), (String)this.handler.root.toPrettyString());
        Assert.assertEquals((String)this.handler.root.at("/user/roles/0").asText(), (String)"admin", (String)this.handler.root.toPrettyString());
        Assert.assertEquals((String)this.handler.root.at("/user/roles/1").asText(), (String)"user", (String)this.handler.root.toPrettyString());
        this.handler.add("user.roles", "manager");
        Assert.assertTrue((boolean)this.handler.root.at("/user/roles").isArray(), (String)this.handler.root.toPrettyString());
        Assert.assertEquals((String)this.handler.root.at("/user/roles/0").asText(), (String)"admin", (String)this.handler.root.toPrettyString());
        Assert.assertEquals((String)this.handler.root.at("/user/roles/1").asText(), (String)"user", (String)this.handler.root.toPrettyString());
        Assert.assertEquals((String)this.handler.root.at("/user/roles/2").asText(), (String)"manager", (String)this.handler.root.toPrettyString());
        this.handler.add("user.data", Map.of("foo", "bar"));
        Assert.assertTrue((boolean)this.handler.root.at("/user/data").isObject(), (String)this.handler.root.toPrettyString());
        Assert.assertEquals((String)this.handler.root.at("/user/data/foo").asText(), (String)"bar", (String)this.handler.root.toPrettyString());
        this.handler.add("user.foo.data", Map.of("foo", "bar"));
        Assert.assertTrue((boolean)this.handler.root.at("/user/foo/data").isObject(), (String)this.handler.root.toPrettyString());
        Assert.assertEquals((String)this.handler.root.at("/user/foo/data/foo").asText(), (String)"bar", (String)this.handler.root.toPrettyString());
        this.handler.add("user.bar.data.foo", true);
        Assert.assertTrue((boolean)this.handler.root.at("/user/bar/data/foo").isBoolean(), (String)this.handler.root.toPrettyString());
        Assert.assertTrue((boolean)this.handler.root.at("/user/bar/data/foo").asBoolean(), (String)this.handler.root.toPrettyString());
        this.handler.remove("user.roles[1]");
        Assert.assertEquals((String)this.handler.root.at("/user/roles/0").asText(), (String)"admin", (String)this.handler.root.toPrettyString());
        Assert.assertEquals((String)this.handler.root.at("/user/roles/1").asText(), (String)"manager", (String)this.handler.root.toPrettyString());
        Assert.assertTrue((boolean)this.handler.root.at("/user/roles/2").isMissingNode());
        this.handler.add("user.nested[1]", Map.of("key2", "value2"));
        Assert.assertEquals((String)this.handler.root.at("/user/nested/0/key1").asText(), (String)"value1", (String)this.handler.root.toPrettyString());
        Assert.assertEquals((String)this.handler.root.at("/user/nested/1/key2").asText(), (String)"value2", (String)this.handler.root.toPrettyString());
    }
}

