/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.primeframework.mvc.parameter.el.CollectionExpressionException;

public class TypeTools {
    public static Class<?> componentFinalType(Type type, String path) {
        while (!(type instanceof Class)) {
            type = TypeTools.componentType(type, path);
        }
        return (Class)type;
    }

    public static Type componentType(Type type, String path) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            if (Map.class.isAssignableFrom(rawType)) {
                return parameterizedType.getActualTypeArguments()[1];
            }
            if (Collection.class.isAssignableFrom(rawType)) {
                return parameterizedType.getActualTypeArguments()[0];
            }
            throw new CollectionExpressionException("Unknown collection type [" + String.valueOf(type) + "]");
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        Class rawType = (Class)type;
        if (Map.class == type || Collection.class == type) {
            throw new CollectionExpressionException("The method or member [" + path + "] returns a simple Map or Collection. Unable to determine the type of the Map or Collection. Please make this method generic so that the correct type can be determined.");
        }
        if (rawType.isArray()) {
            return rawType.getComponentType();
        }
        return rawType;
    }

    public static boolean isGenericMap(Type t) {
        return t instanceof ParameterizedType && Map.class.isAssignableFrom((Class)((ParameterizedType)t).getRawType());
    }

    public static Type[] mapTypes(Type type, String path) {
        ParameterizedType parameterizedType;
        Class rawType;
        if (type instanceof Class) {
            Class c = (Class)type;
            while (c != null && !TypeTools.isGenericMap(type)) {
                Type[] types = c.getGenericInterfaces();
                if (types != null && types.length > 0) {
                    for (Type t : types) {
                        if (!TypeTools.isGenericMap(t)) continue;
                        type = t;
                        break;
                    }
                }
                if (TypeTools.isGenericMap(type)) continue;
                type = c.getGenericSuperclass();
                if (type instanceof Class) {
                    c = (Class)type;
                    continue;
                }
                if (type instanceof ParameterizedType) {
                    c = (Class)((ParameterizedType)type).getRawType();
                    continue;
                }
                c = null;
            }
        }
        if (type instanceof ParameterizedType && Map.class.isAssignableFrom(rawType = (Class)(parameterizedType = (ParameterizedType)type).getRawType())) {
            return parameterizedType.getActualTypeArguments();
        }
        return new Type[]{String.class, Object.class};
    }

    public static Class<?> rawType(Type type) {
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)((Object)type)).getRawType();
        } else if (type instanceof GenericArrayType) {
            Class componentType = (Class)((GenericArrayType)((Object)type)).getGenericComponentType();
            type = Array.newInstance(componentType, 0).getClass();
        }
        return type;
    }

    public static Type resolveGenericType(Class<?> declaringClassGeneric, Class<?> currentClass, TypeVariable<?> typeVariable) {
        Class klass;
        TypeVariable<Class<T>>[] genericTypes;
        ArrayList classes = new ArrayList();
        while (currentClass != declaringClassGeneric) {
            classes.add(currentClass);
            currentClass = currentClass.getSuperclass();
        }
        classes.add(declaringClassGeneric);
        Collections.reverse(classes);
        int position = -1;
        TypeVariable currentTypeVariable = typeVariable;
        Iterator iterator = classes.iterator();
        block1: while (iterator.hasNext() && (genericTypes = (klass = (Class)iterator.next()).getTypeParameters()) != null) {
            if (position != -1) {
                Type genericSuperclass = klass.getGenericSuperclass();
                if (!(genericSuperclass instanceof ParameterizedType)) {
                    throw new IllegalStateException("Something bad happened while trying to resolve generic types. The class [" + String.valueOf(genericSuperclass) + "] was encountered but didn't have generic types. It probably should have.");
                }
                Type[] inheritedGenericTypes = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
                Type nextParameterType = inheritedGenericTypes[position];
                if (nextParameterType instanceof TypeVariable) {
                    currentTypeVariable = (TypeVariable)nextParameterType;
                } else if (nextParameterType instanceof Class) {
                    return nextParameterType;
                }
            }
            String name = currentTypeVariable.getName();
            for (int i = 0; i < genericTypes.length; ++i) {
                if (!genericTypes[i].getName().equals(name)) continue;
                position = i;
                currentTypeVariable = genericTypes[i];
                continue block1;
            }
        }
        return typeVariable;
    }
}

