/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.time.Clock;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.crypto.BadPaddingException;
import org.primeframework.mvc.ErrorException;
import org.primeframework.mvc.security.CookieProxy;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.security.UserIdSessionContext;
import org.primeframework.mvc.security.UserLoginSecurityContext;
import org.primeframework.mvc.util.CookieTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseUserIdCookieSecurityContext<T>
implements UserLoginSecurityContext {
    public static final String UserKey = "primeCurrentUser";
    private static final String ContextKey = "primeLoginContext";
    private static final Logger logger = LoggerFactory.getLogger(BaseUserIdCookieSecurityContext.class);
    protected final CookieProxy sessionCookie;
    private final Clock clock;
    private final Encryptor encryptor;
    private final ObjectMapper objectMapper;
    private final HTTPRequest request;
    private final HTTPResponse response;
    private final Duration sessionMaxAge;
    private final Duration sessionTimeout;

    protected BaseUserIdCookieSecurityContext(HTTPRequest request, HTTPResponse response, Encryptor encryptor, ObjectMapper objectMapper, Clock clock, Duration sessionTimeout, Duration sessionMaxAge) {
        this.request = request;
        this.response = response;
        this.encryptor = encryptor;
        this.objectMapper = objectMapper;
        this.clock = clock;
        this.sessionMaxAge = sessionMaxAge;
        this.sessionTimeout = sessionTimeout;
        long timeoutInSeconds = sessionTimeout.toSeconds();
        this.sessionCookie = new CookieProxy(this.getCookieName(), timeoutInSeconds, Cookie.SameSite.Strict);
    }

    @Override
    public Object getCurrentUser() {
        Object user = this.request.getAttribute(UserKey);
        if (user != null) {
            return user;
        }
        UserIdSessionContext<T> sessionContext = this.resolveContext();
        if (sessionContext == null) {
            return null;
        }
        user = this.retrieveUserById(sessionContext.getUserId());
        this.request.setAttribute(UserKey, user);
        return user;
    }

    @Override
    public String getSessionId() {
        return Optional.ofNullable(this.resolveContext()).map(UserIdSessionContext::getSessionId).orElse(null);
    }

    @Override
    public boolean isLoggedIn() {
        return this.resolveContext() != null;
    }

    @Override
    public void login(Object user) {
        try {
            T id = this.getIdFromUser(user);
            ZonedDateTime now = ZonedDateTime.now(this.clock);
            UserIdSessionContext<T> sessionContext = this.createUserIdSessionContext(id, now);
            if (sessionContext.getSessionId() == null) {
                throw new IllegalArgumentException("Received a null getSessionId from " + String.valueOf(sessionContext.getClass()));
            }
            String cookieValue = CookieTools.toJSONCookie(sessionContext, true, true, this.encryptor, this.objectMapper);
            this.sessionCookie.add(this.request, this.response, cookieValue);
        }
        catch (Exception e) {
            this.deleteCookies();
            throw new ErrorException(e, new Object[0]);
        }
    }

    @Override
    public void logout() {
        this.deleteCookies();
    }

    @Override
    public void updateUser(Object user) {
        Object currentUser = this.request.getAttribute(UserKey);
        if (currentUser != null) {
            this.request.setAttribute(UserKey, user);
        }
    }

    protected abstract UserIdSessionContext<T> createUserIdSessionContext(T var1, ZonedDateTime var2);

    protected String getCookieName() {
        return UserKey;
    }

    protected abstract T getIdFromUser(Object var1);

    protected abstract Class<? extends UserIdSessionContext<T>> getUserIdSessionContextClass();

    protected abstract Object retrieveUserById(T var1);

    CookieExtendResult shouldExtendCookie(ZonedDateTime signInTime) {
        ZonedDateTime maxSessionAgeTime;
        ZonedDateTime now = ZonedDateTime.now(this.clock);
        if (now.isAfter(maxSessionAgeTime = signInTime.plus(this.sessionMaxAge))) {
            return CookieExtendResult.Invalid;
        }
        ZonedDateTime extensionTime = now.plus(this.sessionTimeout);
        if (extensionTime.isAfter(maxSessionAgeTime)) {
            return CookieExtendResult.Keep;
        }
        ZonedDateTime halfWayPoint = signInTime.plusMinutes(this.sessionTimeout.toMinutes() / 2L);
        return now.isAfter(halfWayPoint) ? CookieExtendResult.Extend : CookieExtendResult.Keep;
    }

    private void deleteCookies() {
        this.sessionCookie.delete(this.request, this.response);
    }

    private UserIdSessionContext<T> resolveContext() {
        UserIdSessionContext<T> context = (UserIdSessionContext<T>)this.request.getAttribute(ContextKey);
        if (context != null) {
            return context;
        }
        String cookie = this.sessionCookie.get(this.request);
        if (cookie == null) {
            return null;
        }
        try {
            context = CookieTools.fromJSONCookie(cookie, this.getUserIdSessionContextClass(), true, true, this.encryptor, this.objectMapper);
            CookieExtendResult shouldExtend = this.shouldExtendCookie(context.getLoginInstant());
            switch (shouldExtend.ordinal()) {
                case 1: {
                    this.sessionCookie.add(this.request, this.response, cookie);
                    break;
                }
                case 2: {
                    this.deleteCookies();
                    return null;
                }
            }
            this.request.setAttribute(ContextKey, context);
            return context;
        }
        catch (BadPaddingException e) {
            logger.debug("User cookie parsing failed. It is likely the cookie encryption key has changed, therefore deleting session.", (Throwable)e);
            this.deleteCookies();
            return null;
        }
        catch (Exception e) {
            logger.debug("User cookie parsing failed because decoding or decryption failed, therefore deleting session.", (Throwable)e);
            this.deleteCookies();
            return null;
        }
    }

    static enum CookieExtendResult {
        Keep,
        Extend,
        Invalid;

    }
}

