/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import java.lang.reflect.Type;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.primeframework.mvc.parameter.convert.AbstractGlobalConverter;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.parameter.convert.MultipleParametersUnsupportedException;
import org.primeframework.mvc.parameter.convert.annotation.GlobalConverter;

@GlobalConverter
public class ZoneIdConverter
extends AbstractGlobalConverter {
    @Override
    protected String objectToString(Object value, Type convertFrom, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        ZoneId zoneId = (ZoneId)value;
        return zoneId.toString();
    }

    @Override
    protected Object stringToObject(String value, Type convertTo, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        try {
            return ZoneId.of(value);
        }
        catch (DateTimeException e) {
            throw new ConversionException(e);
        }
    }

    @Override
    protected Object stringsToObject(String[] values, Type convertTo, Map<String, String> attributes, String expression) throws ConversionException, ConverterStateException {
        throw new MultipleParametersUnsupportedException("You are attempting to map a form field that contains multiple parameters to a property on the action class that is of type java.time.ZoneId. This isn't allowed.");
    }
}

