/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import com.google.inject.Inject;
import java.util.Map;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.parameter.convert.annotation.GlobalConverter;
import org.primeframework.mvc.parameter.convert.converters.AbstractPrimitiveConverter;

@GlobalConverter
public class CharacterConverter
extends AbstractPrimitiveConverter {
    @Inject
    public CharacterConverter(MVCConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected Object defaultPrimitive(Class convertTo, Map<String, String> attributes) throws ConversionException, ConverterStateException {
        return Character.valueOf('\u0000');
    }

    @Override
    protected String primitiveToString(Object value, Class convertFrom, Map<String, String> attributes) throws ConversionException, ConverterStateException {
        return value.toString();
    }

    @Override
    protected Object stringToPrimitive(String value, Class convertTo, Map<String, String> attributes) throws ConversionException, ConverterStateException {
        if (value.length() > 1) {
            throw new ConversionException("Conversion from String to character must be a String of length 1 - [" + value + "] is invalid");
        }
        return Character.valueOf(value.charAt(0));
    }
}

