/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.primeframework.mvc.message.MessageType;

public class MessageTypeDeserializer
extends StdDeserializer<MessageType> {
    public MessageTypeDeserializer() {
        super(MessageType.class);
    }

    public MessageType deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        if (node.asText().contentEquals("INFO")) {
            return MessageType.INFO;
        }
        if (node.asText().contentEquals("WARNING")) {
            return MessageType.WARNING;
        }
        return MessageType.ERROR;
    }
}

