/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.freemarker;

import com.google.inject.Inject;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.CollectionModel;
import freemarker.template.Configuration;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import io.fusionauth.http.server.HTTPContext;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.result.ControlsHashModel;
import org.primeframework.mvc.action.result.ModelsHashModel;
import org.primeframework.mvc.control.guice.ControlFactory;
import org.primeframework.mvc.freemarker.guice.TemplateModelFactory;
import org.primeframework.mvc.freemarker.http.ContextModel;
import org.primeframework.mvc.freemarker.http.HTTPRequestModel;
import org.primeframework.mvc.message.FieldMessage;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;
import org.primeframework.mvc.parameter.el.MissingPropertyExpressionException;

public class FreeMarkerMap
implements TemplateHashModelEx {
    public static final String ALL_MESSAGES = "allMessages";
    public static final String CONTEXT = "context";
    public static final String CONTEXT_MODEL = "Context";
    public static final String ERROR_MESSAGES = "errorMessages";
    public static final String FIELD_MESSAGES = "fieldMessages";
    public static final String INFO_MESSAGES = "infoMessages";
    public static final String REQUEST = "request";
    public static final String REQUEST_MODEL = "Request";
    public static final String RESPONSE = "response";
    public static final String WARNING_MESSAGES = "warningMessages";
    protected final ActionInvocationStore actionInvocationStore;
    protected final Configuration configuration;
    protected final HTTPContext context;
    protected final ExpressionEvaluator expressionEvaluator;
    protected final Map<String, Object> objects = new HashMap<String, Object>();
    protected final HTTPRequest request;

    @Inject
    public FreeMarkerMap(HTTPContext context, HTTPRequest request, HTTPResponse response, ExpressionEvaluator expressionEvaluator, ActionInvocationStore actionInvocationStore, MessageStore messageStore, ControlFactory controlFactory, TemplateModelFactory templateModelFactory, Configuration configuration) {
        this.context = context;
        this.request = request;
        this.expressionEvaluator = expressionEvaluator;
        this.actionInvocationStore = actionInvocationStore;
        this.configuration = configuration;
        this.objects.put(CONTEXT_MODEL, new ContextModel(context, configuration.getObjectWrapper()));
        this.objects.put(CONTEXT, context);
        this.objects.put(REQUEST_MODEL, new HTTPRequestModel(request, response, configuration.getObjectWrapper()));
        this.objects.put(REQUEST, request);
        this.objects.put(RESPONSE, response);
        List<Message> allMessages = messageStore.get();
        Map<String, List<FieldMessage>> fieldMessages = messageStore.getFieldMessages();
        ArrayList<Message> errorMessages = new ArrayList<Message>();
        ArrayList<Message> infoMessages = new ArrayList<Message>();
        ArrayList<Message> warningMessages = new ArrayList<Message>();
        for (Message message : allMessages) {
            if (message instanceof FieldMessage) continue;
            if (message.getType() == MessageType.ERROR) {
                errorMessages.add(message);
                continue;
            }
            if (message.getType() == MessageType.INFO) {
                infoMessages.add(message);
                continue;
            }
            if (message.getType() != MessageType.WARNING) continue;
            warningMessages.add(message);
        }
        this.objects.put(ALL_MESSAGES, allMessages);
        this.objects.put(FIELD_MESSAGES, fieldMessages);
        this.objects.put(ERROR_MESSAGES, errorMessages);
        this.objects.put(INFO_MESSAGES, infoMessages);
        this.objects.put(WARNING_MESSAGES, warningMessages);
        for (String prefix : templateModelFactory.prefixes()) {
            this.objects.put(prefix, new ModelsHashModel(prefix, templateModelFactory, configuration.getObjectWrapper()));
        }
        for (String prefix : controlFactory.prefixes()) {
            this.objects.put(prefix, new ControlsHashModel(prefix, controlFactory, configuration.getObjectWrapper()));
        }
    }

    public TemplateModel get(String key) {
        Object value = null;
        Deque<ActionInvocation> actionInvocations = this.actionInvocationStore.getDeque();
        if (actionInvocations != null) {
            for (ActionInvocation actionInvocation : actionInvocations) {
                if (actionInvocation.action == null) continue;
                try {
                    value = this.expressionEvaluator.getValue(key, actionInvocation.action);
                    if (value == null) continue;
                    break;
                }
                catch (MissingPropertyExpressionException missingPropertyExpressionException) {
                }
            }
        }
        if (value == null && this.objects.containsKey(key)) {
            value = this.objects.get(key);
        }
        if (value == null) {
            value = this.request.getAttribute(key);
        }
        if (value == null) {
            value = this.context.getAttribute(key);
        }
        try {
            return this.configuration.getObjectWrapper().wrap(value);
        }
        catch (TemplateModelException e) {
            throw new PrimeException(e);
        }
    }

    public boolean isEmpty() {
        return this.size() > 0;
    }

    public TemplateCollectionModel keys() {
        HashSet<String> keys = new HashSet<String>(this.objects.keySet());
        keys.addAll(this.request.getAttributes().keySet());
        keys.addAll(this.context.getAttributes().keySet());
        Deque<ActionInvocation> actionInvocations = this.actionInvocationStore.getDeque();
        if (actionInvocations != null) {
            for (ActionInvocation actionInvocation : actionInvocations) {
                if (actionInvocation.action == null) continue;
                keys.addAll(actionInvocation.configuration.memberNames);
            }
        }
        return new CollectionModel(keys, (BeansWrapper)this.configuration.getObjectWrapper());
    }

    public Object put(String key, Object value) {
        return this.objects.put(key, value);
    }

    public int size() {
        int size = this.objects.size() + this.request.getAttributes().size() + this.context.getAttributes().size();
        Deque<ActionInvocation> actionInvocations = this.actionInvocationStore.getDeque();
        if (actionInvocations != null) {
            for (ActionInvocation actionInvocation : actionInvocations) {
                if (actionInvocation.action == null) continue;
                size += actionInvocation.configuration.memberNames.size();
            }
        }
        return size;
    }

    public TemplateCollectionModel values() {
        ArrayList<Object> values = new ArrayList<Object>(this.objects.values());
        Deque<ActionInvocation> actionInvocations = this.actionInvocationStore.getDeque();
        if (actionInvocations != null) {
            for (ActionInvocation actionInvocation : actionInvocations) {
                if (actionInvocation.action == null) continue;
                values.addAll(this.expressionEvaluator.getAllMemberValues(actionInvocation.action, actionInvocation.configuration.memberNames));
            }
        }
        values.addAll(this.request.getAttributes().values());
        values.addAll(this.context.getAttributes().values());
        return new CollectionModel(values, (BeansWrapper)this.configuration.getObjectWrapper());
    }
}

