/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.freemarker;

import com.google.inject.Inject;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.primeframework.mvc.freemarker.FreeMarkerRenderException;
import org.primeframework.mvc.freemarker.FreeMarkerService;
import org.primeframework.mvc.freemarker.MissingTemplateException;
import org.primeframework.mvc.locale.LocaleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFreeMarkerService
implements FreeMarkerService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFreeMarkerService.class);
    private final Configuration configuration;
    private final LocaleProvider localeProvider;

    @Inject
    public DefaultFreeMarkerService(Configuration configuration, LocaleProvider localeProvider) {
        this.configuration = configuration;
        this.localeProvider = localeProvider;
    }

    @Override
    public void render(Writer writer, String templateName, Object root) throws FreeMarkerRenderException, MissingTemplateException {
        try {
            long start = System.currentTimeMillis();
            Template template = this.configuration.getTemplate(templateName, (Locale)this.localeProvider.get());
            if (logger.isDebugEnabled()) {
                logger.debug("Freemarker getTemplate took [{}]", (Object)(System.currentTimeMillis() - start));
            }
            start = System.currentTimeMillis();
            template.process(root, writer);
            if (logger.isDebugEnabled()) {
                logger.debug("Freemarker process took [{}]", (Object)(System.currentTimeMillis() - start));
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new MissingTemplateException(fnfe);
        }
        catch (TemplateException | IOException e) {
            throw new FreeMarkerRenderException(e);
        }
    }
}

