/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.guice;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.primeframework.mvc.control.Control;

public class ControlFactory {
    private static final Map<String, Map<String, Class<? extends Control>>> bindings = new HashMap<String, Map<String, Class<? extends Control>>>();
    private final Injector injector;

    @Inject
    public ControlFactory(Injector injector) {
        this.injector = injector;
    }

    public static void addControl(Binder binder, String prefix, String name, Class<? extends Control> controlType) {
        binder.bind(controlType);
        Map controls = bindings.computeIfAbsent(prefix, k -> new HashMap());
        controls.put(name, controlType);
    }

    public Control build(String prefix, String name) {
        Map<String, Class<? extends Control>> controls = bindings.get(prefix);
        if (controls == null) {
            throw new IllegalArgumentException("Unbound control prefix [" + prefix + "]");
        }
        Class<? extends Control> controlType = controls.get(name);
        if (controlType == null) {
            throw new IllegalArgumentException("Control named [" + name + "] is not bound in the prefix [" + prefix + "]");
        }
        return (Control)this.injector.getInstance(controlType);
    }

    public Set<String> controlNames(String prefix) {
        return bindings.get(prefix).keySet();
    }

    public Set<String> prefixes() {
        return bindings.keySet();
    }
}

