/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.content;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPRequest;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.content.ContentHandler;
import org.primeframework.mvc.content.ContentWorkflow;
import org.primeframework.mvc.content.ValidContentTypes;
import org.primeframework.mvc.content.guice.ContentHandlerFactory;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleMessage;
import org.primeframework.mvc.message.l10n.MessageProvider;
import org.primeframework.mvc.validation.ValidationException;
import org.primeframework.mvc.workflow.WorkflowChain;

public class DefaultContentWorkflow
implements ContentWorkflow {
    private final ContentHandlerFactory factory;
    private final MessageProvider messageProvider;
    private final MessageStore messageStore;
    private final HTTPRequest request;
    private final ActionInvocationStore store;

    @Inject
    public DefaultContentWorkflow(MessageStore messageStore, ContentHandlerFactory factory, MessageProvider messageProvider, HTTPRequest request, ActionInvocationStore store) {
        this.factory = factory;
        this.messageProvider = messageProvider;
        this.messageStore = messageStore;
        this.request = request;
        this.store = store;
    }

    @Override
    public void perform(WorkflowChain workflowChain) throws IOException {
        ContentHandler handler;
        String contentType = this.request.getContentType();
        if (this.request.hasBody()) {
            this.validateContentType(contentType);
        }
        if ((handler = this.factory.build(contentType)) != null) {
            handler.handle();
        }
        workflowChain.continueWorkflow();
        if (handler != null) {
            handler.cleanup();
        }
    }

    private void validateContentType(String contentType) {
        ActionInvocation actionInvocation;
        if (contentType != null && !contentType.equals("") && (actionInvocation = this.store.getCurrent()) != null && actionInvocation.configuration != null) {
            Annotation annotation;
            Set<String> validContentTypes = actionInvocation.configuration.validContentTypes;
            Annotation annotation2 = annotation = actionInvocation.method != null ? actionInvocation.method.annotations.get(ValidContentTypes.class) : null;
            if (annotation != null) {
                validContentTypes = Set.of(((ValidContentTypes)annotation).value());
            }
            if (!validContentTypes.isEmpty() && !validContentTypes.contains(contentType)) {
                this.messageStore.add(new SimpleMessage(MessageType.ERROR, "[InvalidContentType]", this.messageProvider.getMessage("[InvalidContentType]", contentType, String.join((CharSequence)", ", validContentTypes.stream().sorted().toList()))));
                throw new ValidationException();
            }
        }
    }
}

