/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPResponse;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import org.apache.commons.lang3.StringUtils;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.result.AbstractResult;
import org.primeframework.mvc.action.result.annotation.Stream;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;
import org.primeframework.mvc.util.DateTools;
import org.primeframework.mvc.util.EncodingUtils;

public class StreamResult
extends AbstractResult<Stream> {
    private final ActionInvocationStore actionInvocationStore;
    private final HTTPResponse response;

    @Inject
    public StreamResult(ExpressionEvaluator expressionEvaluator, HTTPResponse response, ActionInvocationStore actionInvocationStore) {
        super(expressionEvaluator);
        this.response = response;
        this.actionInvocationStore = actionInvocationStore;
    }

    @Override
    public boolean execute(Stream stream) throws IOException {
        Object object2;
        ActionInvocation actionInvocation = this.actionInvocationStore.getCurrent();
        Object action = actionInvocation.action;
        String property = stream.property();
        String lastModifiedProperty = stream.lastModifiedProperty();
        String length = this.expand(stream.length(), action, false);
        String name = this.expand(stream.name(), action, false);
        String type = this.expand(stream.type(), action, false);
        ZonedDateTime lastModified = null;
        try {
            object2 = this.expressionEvaluator.getValue(lastModifiedProperty, action);
            if (!(object2 instanceof ZonedDateTime)) {
                throw new PrimeException("Invalid property [" + property + "] for Stream result. This property returned null or an Object that is not an InputStream.");
            }
            lastModified = (ZonedDateTime)object2;
        }
        catch (Exception object2) {
            // empty catch block
        }
        this.response.setStatus(stream.status());
        this.response.setContentType(type);
        if (StringUtils.isNotBlank(length)) {
            this.response.setContentLength(Long.parseLong(length));
        }
        if (StringUtils.isNotBlank(name)) {
            this.response.setHeader("Content-Disposition", "attachment; filename=\"" + EncodingUtils.escapedQuotedString(name) + "\"; filename*=UTF-8''" + EncodingUtils.rfc5987_encode(name));
        }
        if (lastModified != null) {
            this.response.setHeader("Last-Modified", lastModified.format(DateTools.RFC_5322_DATE_TIME));
        }
        this.addCacheControlHeader(stream, this.response);
        object2 = this.expressionEvaluator.getValue(property, action);
        if (object2 != null && !(object2 instanceof InputStream)) {
            throw new PrimeException("Invalid property [" + property + "] for Stream result. This property is of type [" + object2.getClass().getSimpleName() + "] but it must be an InputStream.");
        }
        if (!this.isHeadRequest(actionInvocation) && object2 == null) {
            throw new PrimeException("Invalid property [" + property + "] for Stream result. This property is must not be null unless the HTTP method is [HEAD].");
        }
        try (InputStream is = (InputStream)object2;){
            if (this.isHeadRequest(actionInvocation)) {
                boolean bl = true;
                return bl;
            }
            is.transferTo(this.response.getOutputStream());
        }
        return true;
    }

    @Override
    protected String getCacheControl(Stream result) {
        return result.cacheControl();
    }

    @Override
    protected boolean getDisableCacheControl(Stream result) {
        return result.disableCacheControl();
    }
}

