/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.fusionauth.http.log.LoggerFactory;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPServer;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.HTTPUnexpectedExceptionHandler;
import io.fusionauth.http.server.Instrumenter;
import java.util.LinkedList;
import java.util.List;
import org.primeframework.mvc.PrimeMVCInstrumenter;
import org.primeframework.mvc.PrimeMVCRequestHandler;
import org.primeframework.mvc.PrimeMVCUnexpectedExceptionHandler;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.guice.GuiceBootstrap;
import org.primeframework.mvc.log.SLF4JLoggerFactoryAdapter;

public abstract class BasePrimeMain {
    protected Injector injector;
    private PrimeMVCInstrumenter instrumenter;
    private List<PrimeHTTPServer> servers = new LinkedList<PrimeHTTPServer>();

    public abstract HTTPServerConfiguration[] configuration();

    public Injector getInjector() {
        return this.injector;
    }

    public void hup() {
        this.injector = GuiceBootstrap.initialize(this.modules());
        this.injector.injectMembers((Object)this);
        this.servers.forEach(server -> server.handler.updateInjector(this.injector));
        this.instrumenter.updateInjector(this.injector);
    }

    public void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new PrimeHTTPServerShutdown());
    }

    public void shutdown() {
        this.servers.forEach(server -> {
            server.server.close();
            server.handler.close();
        });
    }

    public void start() {
        this.instrumenter = new PrimeMVCInstrumenter();
        this.hup();
        for (HTTPServerConfiguration config : this.configuration()) {
            PrimeMVCRequestHandler requestHandler = new PrimeMVCRequestHandler(this.injector);
            this.configureLoggerFactory(config);
            MVCConfiguration mvcConfiguration = (MVCConfiguration)this.injector.getInstance(MVCConfiguration.class);
            long mvcMaxFileSize = mvcConfiguration.fileUploadMaxSize();
            long httpMaxFileSize = config.getMultipartConfiguration().getMaxFileSize();
            if (mvcMaxFileSize < httpMaxFileSize) {
                throw new IllegalStateException("MVCConfiguration.fileUploadMaxSize must be greater than or equal to the HTTP server configuration. Prime MVC configuration [" + mvcMaxFileSize + "] HTTP server configuration [" + httpMaxFileSize + "]");
            }
            HTTPServer server2 = (HTTPServer)((HTTPServer)((HTTPServer)new HTTPServer().withConfiguration(config).withHandler((HTTPHandler)requestHandler)).withUnexpectedExceptionHandler((HTTPUnexpectedExceptionHandler)new PrimeMVCUnexpectedExceptionHandler())).withInstrumenter((Instrumenter)this.instrumenter);
            this.servers.add(new PrimeHTTPServer(requestHandler, server2));
        }
        this.servers.forEach(server -> server.server.start());
    }

    protected abstract Module[] modules();

    private void configureLoggerFactory(HTTPServerConfiguration config) {
        if (config.getLoggerFactory() == null || config.getLoggerFactory().getClass().equals(new HTTPServerConfiguration().getLoggerFactory().getClass())) {
            config.withLoggerFactory((LoggerFactory)new SLF4JLoggerFactoryAdapter());
        }
    }

    private class PrimeHTTPServerShutdown
    extends Thread {
        private PrimeHTTPServerShutdown() {
        }

        @Override
        public void run() {
            BasePrimeMain.this.shutdown();
        }
    }

    private static class PrimeHTTPServer {
        public final PrimeMVCRequestHandler handler;
        public final HTTPServer server;

        private PrimeHTTPServer(PrimeMVCRequestHandler handler, HTTPServer server) {
            this.handler = handler;
            this.server = server;
        }
    }
}

