/*
 * Copyright (c) 2022, Inversoft Inc., All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package org.primeframework.mvc.io;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

/**
 * An internal only output stream that removes the need to make a copy of the byte array in order to use it.
 *
 * @author Brian Pontarelli
 */
public class PrimeByteArrayOutputStream extends ByteArrayOutputStream {
  public PrimeByteArrayOutputStream() {
    super();
  }

  public PrimeByteArrayOutputStream(int size) {
    super(size);
  }

  public ByteBuffer toByteBuffer() {
    return ByteBuffer.wrap(buf, 0, count);
  }
}
