/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.content;

import com.google.inject.Inject;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import org.easymock.EasyMock;
import org.example.action.KitchenSinkAction;
import org.example.domain.UserField;
import org.example.domain.UserType;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.ExecuteMethodConfiguration;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.content.DefaultContentWorkflow;
import org.primeframework.mvc.content.binary.BinaryActionConfiguration;
import org.primeframework.mvc.content.guice.ContentHandlerFactory;
import org.primeframework.mvc.content.json.JacksonActionConfiguration;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.l10n.MessageProvider;
import org.primeframework.mvc.workflow.WorkflowChain;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class DefaultContentWorkflowTest
extends PrimeBaseTest {
    @Inject
    public MessageProvider messageProvider;
    @Inject
    public MessageStore messageStore;
    @Inject
    public ActionInvocationStore store;

    @Test
    public void binary() throws Exception {
        this.test.createFile("Binary File!");
        try (InputStream inputStream = Files.newInputStream(this.test.tempFile, new OpenOption[0]);){
            this.request.setContentLength(Long.valueOf(Files.size(this.test.tempFile)));
            this.request.setContentType("application/octet-stream");
            this.request.setInputStream(inputStream);
            HashMap<Class<BinaryActionConfiguration>, BinaryActionConfiguration> hashMap = new HashMap<Class<BinaryActionConfiguration>, BinaryActionConfiguration>();
            hashMap.put(BinaryActionConfiguration.class, new BinaryActionConfiguration("binaryRequest", null));
            KitchenSinkAction kitchenSinkAction = new KitchenSinkAction(null);
            ActionConfiguration actionConfiguration = new ActionConfiguration(KitchenSinkAction.class, false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Collections.emptyList(), null, hashMap, null, null, null, null, null);
            this.store.setCurrent(new ActionInvocation((Object)kitchenSinkAction, null, null, null, actionConfiguration));
            WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
            workflowChain.continueWorkflow();
            EasyMock.replay((Object[])new Object[]{workflowChain});
            new DefaultContentWorkflow(this.messageStore, new ContentHandlerFactory(injector), this.messageProvider, this.request, this.store).perform(workflowChain);
            AssertJUnit.assertNotNull((Object)kitchenSinkAction.binaryRequest);
            Assert.assertFalse((boolean)Files.exists(kitchenSinkAction.binaryRequest, new LinkOption[0]));
        }
    }

    @Test
    public void callJSON() throws IOException {
        String string = "{  \"active\":true,  \"addresses\":{    \"home\":{      \"city\":\"Broomfield\",      \"state\":\"Colorado\",      \"zipcode\":\"80023\"    },    \"work\":{      \"city\":\"Denver\",      \"state\":\"Colorado\",      \"zipcode\":\"80202\"    }  },  \"age\":37,  \"favoriteMonth\":5,  \"favoriteYear\":1976,  \"ids\":{    \"0\":1,    \"1\":2  },  \"lifeStory\":\"Hello world\",  \"securityQuestions\":[\"one\",\"two\",\"three\",\"four\"],  \"siblings\":[{    \"active\":false,    \"name\":\"Brett\"  },{    \"active\":false,    \"name\":\"Beth\"  }],  \"type\":\"COOL\"}";
        this.request.setInputStream((InputStream)new ByteArrayInputStream(string.getBytes()));
        this.request.setContentLength(Long.valueOf(string.getBytes().length));
        this.request.setContentType("application/json");
        HashMap<Class<JacksonActionConfiguration>, JacksonActionConfiguration> hashMap = new HashMap<Class<JacksonActionConfiguration>, JacksonActionConfiguration>();
        HashMap<HTTPMethod, JacksonActionConfiguration.RequestMember> hashMap2 = new HashMap<HTTPMethod, JacksonActionConfiguration.RequestMember>();
        hashMap2.put(HTTPMethod.POST, new JacksonActionConfiguration.RequestMember("jsonRequest", UserField.class));
        hashMap.put(JacksonActionConfiguration.class, new JacksonActionConfiguration(hashMap2, null, null));
        KitchenSinkAction kitchenSinkAction = new KitchenSinkAction(null);
        ActionConfiguration actionConfiguration = new ActionConfiguration(KitchenSinkAction.class, false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Collections.emptyList(), null, hashMap, null, null, null, null, null);
        this.store.setCurrent(new ActionInvocation((Object)kitchenSinkAction, new ExecuteMethodConfiguration(HTTPMethod.POST, null, null), null, null, actionConfiguration));
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        new DefaultContentWorkflow(this.messageStore, new ContentHandlerFactory(injector), this.messageProvider, this.request, this.store).perform(workflowChain);
        Assert.assertEquals((String)kitchenSinkAction.jsonRequest.addresses.get((Object)"work").city, (String)"Denver");
        Assert.assertEquals((String)kitchenSinkAction.jsonRequest.addresses.get((Object)"work").state, (String)"Colorado");
        Assert.assertEquals((String)kitchenSinkAction.jsonRequest.addresses.get((Object)"work").zipcode, (String)"80202");
        Assert.assertEquals((String)kitchenSinkAction.jsonRequest.addresses.get((Object)"home").city, (String)"Broomfield");
        Assert.assertEquals((String)kitchenSinkAction.jsonRequest.addresses.get((Object)"home").state, (String)"Colorado");
        Assert.assertEquals((String)kitchenSinkAction.jsonRequest.addresses.get((Object)"home").zipcode, (String)"80023");
        Assert.assertTrue((boolean)kitchenSinkAction.jsonRequest.active);
        Assert.assertEquals((int)kitchenSinkAction.jsonRequest.age, (int)37);
        Assert.assertEquals((int)kitchenSinkAction.jsonRequest.favoriteMonth, (int)5);
        Assert.assertEquals((int)kitchenSinkAction.jsonRequest.favoriteYear, (int)1976);
        Assert.assertEquals((int)kitchenSinkAction.jsonRequest.ids.get(0), (int)1);
        Assert.assertEquals((int)kitchenSinkAction.jsonRequest.ids.get(1), (int)2);
        Assert.assertEquals((String)kitchenSinkAction.jsonRequest.lifeStory, (String)"Hello world");
        Assert.assertEquals((Object[])kitchenSinkAction.jsonRequest.securityQuestions, (Object[])new String[]{"one", "two", "three", "four"});
        Assert.assertEquals((String)kitchenSinkAction.jsonRequest.siblings.get((int)0).name, (String)"Brett");
        Assert.assertEquals((String)kitchenSinkAction.jsonRequest.siblings.get((int)1).name, (String)"Beth");
        Assert.assertEquals((Object)((Object)kitchenSinkAction.jsonRequest.type), (Object)((Object)UserType.COOL));
    }

    @Test
    public void missing() throws IOException {
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.setContentType("application/missing");
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        new DefaultContentWorkflow(this.messageStore, new ContentHandlerFactory(injector), this.messageProvider, hTTPRequest, this.store).perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{workflowChain});
    }
}

