/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action;

import com.google.inject.Injector;
import io.fusionauth.http.HTTPMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.example.action.user.EditAction;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.ActionMapper;
import org.primeframework.mvc.action.DefaultActionMapper;
import org.primeframework.mvc.action.DefaultActionMappingWorkflow;
import org.primeframework.mvc.action.ExecuteMethodConfiguration;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.action.config.ActionConfigurationProvider;
import org.primeframework.mvc.workflow.WorkflowChain;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultActionMappingWorkflowTest
extends PrimeBaseTest {
    @Test
    public void extension() throws Exception {
        this.request.setPath("/admin/user/edit.xml");
        this.request.setMethod(HTTPMethod.POST);
        this.request.addURLParameter("submit", "Submit");
        this.run("/admin/user/edit.xml", "/admin/user/edit", "xml");
    }

    @Test
    public void requestURI() throws Exception {
        this.request.setPath("/admin/user/edit");
        this.request.setMethod(HTTPMethod.POST);
        this.request.addURLParameter("submit", "Submit");
        this.run("/admin/user/edit", "/admin/user/edit", null);
    }

    @Test
    public void requestURIContext() throws Exception {
        this.request.setPath("/context-path/admin/user/edit");
        this.request.setContextPath("/context-path");
        this.request.setMethod(HTTPMethod.POST);
        this.request.addURLParameter("submit", "Submit");
        this.run("/admin/user/edit", "/admin/user/edit", null);
    }

    private void run(String string, String string2, String string3) throws Exception {
        HashMap<HTTPMethod, ExecuteMethodConfiguration> hashMap = new HashMap<HTTPMethod, ExecuteMethodConfiguration>();
        hashMap.put(HTTPMethod.POST, new ExecuteMethodConfiguration(HTTPMethod.POST, EditAction.class.getMethod("post", new Class[0]), null));
        ActionConfigurationProvider actionConfigurationProvider = (ActionConfigurationProvider)EasyMock.createStrictMock(ActionConfigurationProvider.class);
        EasyMock.expect((Object)actionConfigurationProvider.lookup(string)).andReturn((Object)new ActionInvocation(EditAction.class, null, string2, string3, new ActionConfiguration(EditAction.class, false, null, hashMap, new HashMap(), new ArrayList(), new HashMap(), new HashMap(), new ArrayList(), new HashMap(), new ArrayList(), new HashMap(), new HashMap(), null, new HashMap(), new HashSet(), new ArrayList(), new ArrayList(), new HashMap(), string2, new ArrayList(), null, null, null)));
        EasyMock.replay((Object[])new Object[]{actionConfigurationProvider});
        Capture capture = Capture.newInstance();
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        actionInvocationStore.setCurrent((ActionInvocation)EasyMock.capture((Capture)capture));
        actionInvocationStore.removeCurrent();
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        Injector injector = (Injector)EasyMock.createStrictMock(Injector.class);
        EasyMock.expect((Object)((EditAction)injector.getInstance(EditAction.class))).andReturn((Object)new EditAction());
        EasyMock.replay((Object[])new Object[]{injector});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        DefaultActionMappingWorkflow defaultActionMappingWorkflow = new DefaultActionMappingWorkflow(this.request, this.response, actionInvocationStore, (ActionMapper)new DefaultActionMapper(actionConfigurationProvider, injector));
        defaultActionMappingWorkflow.perform(workflowChain);
        ActionInvocation actionInvocation = (ActionInvocation)capture.getValue();
        Assert.assertEquals((String)actionInvocation.actionURI, (String)string2);
        Assert.assertEquals((String)actionInvocation.extension, (String)string3);
        Assert.assertNotNull((Object)actionInvocation.configuration);
        Assert.assertTrue((boolean)actionInvocation.executeResult);
        EasyMock.verify((Object[])new Object[]{actionConfigurationProvider, actionInvocationStore, injector, workflowChain});
    }
}

