/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.server.HTTPContext;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Function;
import org.example.domain.User;
import org.primeframework.mock.MockUserAgent;
import org.primeframework.mvc.security.MockUserLoginSecurityContext;
import org.primeframework.mvc.security.UserLoginSecurityContext;
import org.primeframework.mvc.test.RequestResult;
import org.primeframework.mvc.test.RequestSimulator;
import org.primeframework.mvc.util.ThrowingCallable;
import org.testng.Assert;

public class TestBuilder {
    public HTTPContext context;
    public Function<ObjectMapper, ObjectMapper> objectMapperFunction;
    public RequestResult requestResult;
    @Inject
    public UserLoginSecurityContext securityContext;
    public RequestSimulator simulator;
    public Path tempFile;
    public MockUserAgent userAgent;

    public TestBuilder assertContextAttributeNotNull(String string) {
        Assert.assertNotNull((Object)this.context.getAttribute(string));
        return this;
    }

    public TestBuilder assertCookie(String string, String string2) {
        Cookie cookie2 = this.userAgent.getCookies(this.requestResult.request).stream().filter(cookie -> cookie.name.equals(string)).findFirst().orElse(null);
        Assert.assertNotNull((Object)cookie2);
        Assert.assertEquals((String)cookie2.value, (String)string2);
        return this;
    }

    public TestBuilder configureObjectMapper(Function<ObjectMapper, ObjectMapper> function) {
        this.objectMapperFunction = function;
        return this;
    }

    public TestBuilder createFile() throws IOException {
        return this.createFile("Test File");
    }

    public TestBuilder createFile(String string) throws IOException {
        String string2 = System.getProperty("java.io.tmpdir");
        String string3 = new String(Base64.getEncoder().encode(UUID.randomUUID().toString().getBytes()), StandardCharsets.UTF_8).substring(0, 5);
        this.tempFile = Path.of(string2 + "/_prime_testFile_" + string3, new String[0]);
        this.tempFile.toFile().deleteOnExit();
        Files.write(this.tempFile, string.getBytes(), new OpenOption[0]);
        return this;
    }

    public <T> TestIterator<T> forEach(T ... TArray) {
        return new TestIterator<T>(this, TArray);
    }

    public TestBuilder loginUserWithRole(String ... stringArray) {
        this.securityContext.logout();
        MockUserLoginSecurityContext.roles.clear();
        MockUserLoginSecurityContext.roles.addAll(Arrays.asList(stringArray));
        this.securityContext.login((Object)new User());
        return this;
    }

    public TestBuilder simulate(ThrowingCallable<RequestResult> throwingCallable) throws Exception {
        this.requestResult = throwingCallable.call();
        return this;
    }

    public static class TestIterator<T> {
        public Collection<T> collection;
        public TestBuilder testBuilder;

        public TestIterator(TestBuilder testBuilder, T ... TArray) {
            this.collection = Arrays.asList(TArray);
            this.testBuilder = testBuilder;
        }

        public TestBuilder test(RequestResult.ThrowingConsumer<T> throwingConsumer) throws Exception {
            for (T t : this.collection) {
                throwingConsumer.accept(t);
            }
            return this.testBuilder;
        }
    }
}

