/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import io.fusionauth.http.server.HTTPServerConfiguration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.example.action.user.EditAction;
import org.primeframework.mvc.MockConfiguration;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.TestPrimeMain;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.cors.CORSConfigurationProvider;
import org.primeframework.mvc.cors.NoCORSConfigurationProvider;
import org.primeframework.mvc.guice.MVCModule;
import org.primeframework.mvc.http.HTTPObjectsHolder;
import org.primeframework.mvc.message.TestMessageObserver;
import org.primeframework.mvc.security.MockOAuthUserLoginSecurityContext;
import org.primeframework.mvc.security.UserLoginSecurityContext;
import org.primeframework.mvc.test.RequestBuilder;
import org.primeframework.mvc.test.RequestSimulator;
import org.primeframework.mvc.util.UnsafeTrustManager;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TLSTest {
    public RequestSimulator simulator;

    @AfterClass
    public void afterClass() {
        this.simulator.shutdown();
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, null, null);
            SSLContext.setDefault(sSLContext);
            RequestBuilder.resetHttpClientInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @AfterMethod
    public void afterMethod() {
        HTTPObjectsHolder.clearRequest();
        HTTPObjectsHolder.clearResponse();
    }

    @BeforeClass
    public void beforeClass() throws IOException, GeneralSecurityException {
        MVCModule mVCModule = new MVCModule(this){

            protected void configure() {
                super.configure();
                this.bind(MVCConfiguration.class).toInstance((Object)new MockConfiguration());
                this.bind(UserLoginSecurityContext.class).to(MockOAuthUserLoginSecurityContext.class);
                this.bind(CORSConfigurationProvider.class).to(NoCORSConfigurationProvider.class);
            }
        };
        String string = Files.readString(Paths.get("src/test/resources/testcert.pem", new String[0]));
        String string2 = Files.readString(Paths.get("src/test/resources/testcert.key", new String[0]));
        Module module = Modules.override((Module[])new Module[]{mVCModule}).with(new Module[]{new PrimeBaseTest.TestContentModule()});
        HTTPServerConfiguration hTTPServerConfiguration = new HTTPServerConfiguration().withListener(new HTTPListenerConfiguration(9081, string, string2));
        TestPrimeMain testPrimeMain = new TestPrimeMain(new HTTPServerConfiguration[]{hTTPServerConfiguration}, module);
        this.simulator = new RequestSimulator(testPrimeMain, new TestMessageObserver(), 0, 9081);
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, new TrustManager[]{new UnsafeTrustManager()}, null);
            SSLContext.setDefault(sSLContext);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        RequestBuilder.resetHttpClientInstance();
    }

    @BeforeMethod
    public void beforeMethod() {
        HTTPObjectsHolder.setRequest((HTTPRequest)new HTTPRequest());
        HTTPObjectsHolder.setResponse((HTTPResponse)new HTTPResponse());
    }

    @Test
    public void tls() throws IOException {
        this.simulator.withTLS(true).test("/user/edit").get().assertStatusCode(200).assertHeaderContains("Cache-Control", "no-cache").assertHeaderContains("cache-control", "no-cache").assertHeaderDoesNotContain("Potato").assertBodyFile(Path.of("src/test/resources/html/edit.html", new String[0]), new Object[0]);
        EditAction.getCalled = false;
        this.simulator.withTLS(true).test("/user/edit").withHeader("X-HTTP-Method-Override", "GET").get().assertStatusCode(200);
        Assert.assertTrue((boolean)EditAction.getCalled);
    }
}

