/*
 * Decompiled with CFR 0.152.
 */
package org.example.action.oauth;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.jwt.JWTEncoder;
import io.fusionauth.jwt.Signer;
import io.fusionauth.jwt.domain.JWT;
import io.fusionauth.jwt.hmac.HMACSigner;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import org.example.action.oauth.LoginAction;
import org.primeframework.mvc.action.annotation.Action;
import org.primeframework.mvc.action.result.annotation.JSON;
import org.primeframework.mvc.content.json.annotation.JSONResponse;
import org.primeframework.mvc.parameter.annotation.FieldName;
import org.primeframework.mvc.parameter.annotation.UnknownParameters;
import org.primeframework.mvc.security.MockOAuthUserLoginSecurityContext;
import org.primeframework.mvc.security.oauth.RefreshResponse;
import org.testng.Assert;

@Action
@JSON
public class TokenAction {
    @UnknownParameters
    public static Map<String, String[]> UnknownParameters = new HashMap<String, String[]>();
    @FieldName(value="client_id")
    public String clientId;
    @FieldName(value="client_secret")
    public String clientSecret;
    public String grant_type;
    public String refresh_token;
    @JSONResponse
    public RefreshResponse response = new RefreshResponse();
    @Inject
    private HTTPRequest httpRequest;

    public String post() {
        Assert.assertEquals((String)this.grant_type, (String)"refresh_token");
        Assert.assertEquals((String)this.refresh_token, (String)"prime-refresh-token-value");
        switch (MockOAuthUserLoginSecurityContext.tokenAuthenticationMethod) {
            case client_secret_post: {
                Assert.assertEquals((String)this.clientId, (String)"the client ID");
                Assert.assertEquals((String)this.clientSecret, (String)"the client secret");
                break;
            }
            case client_secret_basic: {
                Assert.assertEquals((String)this.httpRequest.getHeader("Authorization"), (String)"Basic dGhlIGNsaWVudCBJRDp0aGUgY2xpZW50IHNlY3JldA==");
                break;
            }
            case none: {
                Assert.assertTrue((boolean)true);
            }
        }
        JWT jWT = new JWT();
        jWT.audience = "prime-tests";
        jWT.issuedAt = ZonedDateTime.now(ZoneOffset.UTC);
        jWT.expiration = jWT.issuedAt.plusMinutes(1L);
        jWT.issuer = "Prime";
        jWT.subject = LoginAction.Subject;
        this.response.access_token = new JWTEncoder().encode(jWT, (Signer)HMACSigner.newSHA256Signer((String)"secret"));
        return "success";
    }
}

