/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import org.apache.commons.lang3.ArrayUtils;
import org.primeframework.mvc.MockConfiguration;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.converters.BooleanConverter;
import org.primeframework.mvc.parameter.convert.converters.CharacterConverter;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CharacterConverterTest {
    @Test
    public void fromStrings() {
        CharacterConverter characterConverter = new CharacterConverter((MVCConfiguration)new MockConfiguration());
        Character c = (Character)characterConverter.convertFromStrings(Character.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}));
        Assert.assertNull((Object)c);
        char c2 = ((Character)characterConverter.convertFromStrings(Character.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}))).charValue();
        Assert.assertEquals((char)c2, (char)'\u0000');
        c = (Character)characterConverter.convertFromStrings(Character.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"c"}));
        Assert.assertEquals((char)c.charValue(), (char)'c');
        c2 = ((Character)characterConverter.convertFromStrings(Character.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"c"}))).charValue();
        Assert.assertEquals((char)c2, (char)'c');
        c = (Character)characterConverter.convertFromStrings(Character.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{" "}));
        Assert.assertNull((Object)c);
        c2 = ((Character)characterConverter.convertFromStrings(Character.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{" "}))).charValue();
        Assert.assertEquals((int)c2, (int)0);
        Character[] characterArray = (Character[])characterConverter.convertFromStrings(Character[].class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"c", "d"}));
        Assert.assertEquals((Character)characterArray[0], (Character)Character.valueOf('c'));
        Assert.assertEquals((Character)characterArray[1], (Character)Character.valueOf('d'));
        char[] cArray = (char[])characterConverter.convertFromStrings(char[].class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"c", "d"}));
        Assert.assertEquals((char)cArray[0], (char)'c');
        Assert.assertEquals((char)cArray[1], (char)'d');
        try {
            characterConverter.convertFromStrings(Character.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"bad"}));
            Assert.fail((String)"Should have failed");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            characterConverter.convertFromStrings(Character.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"bad"}));
            Assert.fail((String)"Should have failed");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    @Test
    public void toStrings() {
        BooleanConverter booleanConverter = new BooleanConverter((MVCConfiguration)new MockConfiguration());
        String string = booleanConverter.convertToString(Character.class, null, "testExpr", null);
        Assert.assertNull((Object)string);
        string = booleanConverter.convertToString(Character.class, null, "testExpr", (Object)Character.valueOf('c'));
        Assert.assertEquals((String)string, (String)"c");
        string = booleanConverter.convertToString(Character.TYPE, null, "testExpr", (Object)Character.valueOf('c'));
        Assert.assertEquals((String)string, (String)"c");
    }
}

