/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.message.l10n;

import io.fusionauth.http.server.HTTPContext;
import java.nio.file.Path;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.easymock.EasyMock;
import org.example.action.AlternateMessageResourcesAnnotatedAction;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.action.config.DefaultActionConfigurationBuilder;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.container.ContainerResolver;
import org.primeframework.mvc.container.ServletContainerResolver;
import org.primeframework.mvc.locale.LocaleProvider;
import org.primeframework.mvc.message.l10n.MissingMessageException;
import org.primeframework.mvc.message.l10n.ResourceBundleMessageProvider;
import org.primeframework.mvc.message.l10n.WebControl;
import org.primeframework.mvc.util.DefaultURIBuilder;
import org.primeframework.mvc.util.URIBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResourceBundleMessageProviderTest
extends PrimeBaseTest {
    private static final ActionConfiguration actionConfiguration = new DefaultActionConfigurationBuilder((URIBuilder)new DefaultURIBuilder(), Set.of()).build(AlternateMessageResourcesAnnotatedAction.class);

    @Test
    public void defaultMessages() {
        HTTPContext hTTPContext = new HTTPContext(Path.of("src/test/java", new String[0]));
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/l10n/", null, actionConfiguration)).times(4);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        LocaleProvider localeProvider = (LocaleProvider)EasyMock.createStrictMock(LocaleProvider.class);
        EasyMock.expect((Object)((Locale)localeProvider.get())).andReturn((Object)Locale.US).anyTimes();
        EasyMock.replay((Object[])new Object[]{localeProvider});
        ResourceBundleMessageProvider resourceBundleMessageProvider = new ResourceBundleMessageProvider(localeProvider, (ResourceBundle.Control)new WebControl((ContainerResolver)new ServletContainerResolver(hTTPContext), (MVCConfiguration)configuration), actionInvocationStore);
        Assert.assertEquals((String)resourceBundleMessageProvider.getMessage("[blank]foo.bar", new Object[0]), (String)"Required (foo.bar)");
        Assert.assertEquals((String)resourceBundleMessageProvider.getMessage("[blank]baz", new Object[0]), (String)"Required (default)");
        try {
            resourceBundleMessageProvider.getMessage("[not_found]bar", new Object[0]);
            Assert.fail((String)"Should have failed");
        }
        catch (MissingMessageException missingMessageException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{actionInvocationStore});
    }

    @Test
    public void findMessage_Multiple() {
        HTTPContext hTTPContext = new HTTPContext(Path.of("src/test/web", new String[0]));
        LocaleProvider localeProvider = (LocaleProvider)EasyMock.mock(LocaleProvider.class);
        EasyMock.expect((Object)((Locale)localeProvider.get())).andReturn((Object)Locale.US).anyTimes();
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.mock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/alternate-message-resources-annotated", null, actionConfiguration)).anyTimes();
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        EasyMock.replay((Object[])new Object[]{localeProvider});
        ResourceBundleMessageProvider resourceBundleMessageProvider = new ResourceBundleMessageProvider(localeProvider, (ResourceBundle.Control)new WebControl((ContainerResolver)new ServletContainerResolver(hTTPContext), (MVCConfiguration)configuration), actionInvocationStore);
        Assert.assertEquals((String)resourceBundleMessageProvider.getMessage("format_key", new Object[]{"b", "a", "c"}), (String)"Super Package Message b a c");
        Assert.assertEquals((String)resourceBundleMessageProvider.getMessage("normal_message", new Object[0]), (String)"Normal message");
        Assert.assertEquals((String)resourceBundleMessageProvider.getMessage("nested_message", new Object[0]), (String)"Nested message");
    }

    @Test
    public void format() {
        HTTPContext hTTPContext = new HTTPContext(Path.of("src/test/java", new String[0]));
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/l10n/Test", null, actionConfiguration));
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/l10n/NonExistent", null, actionConfiguration));
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/badPackage/Test", null, actionConfiguration));
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/l10n/Test", null, actionConfiguration));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        LocaleProvider localeProvider = (LocaleProvider)EasyMock.createStrictMock(LocaleProvider.class);
        EasyMock.expect((Object)((Locale)localeProvider.get())).andReturn((Object)Locale.US).times(9);
        EasyMock.expect((Object)((Locale)localeProvider.get())).andReturn((Object)Locale.GERMAN).times(3);
        EasyMock.replay((Object[])new Object[]{localeProvider});
        ResourceBundleMessageProvider resourceBundleMessageProvider = new ResourceBundleMessageProvider(localeProvider, (ResourceBundle.Control)new WebControl((ContainerResolver)new ServletContainerResolver(hTTPContext), (MVCConfiguration)configuration), actionInvocationStore);
        Assert.assertEquals((String)resourceBundleMessageProvider.getMessage("format_key", new Object[]{"b", "a", "c"}), (String)"American English Message b a c");
        Assert.assertEquals((String)resourceBundleMessageProvider.getMessage("format_key", new Object[]{"b", "a", "c"}), (String)"Package Message b a c");
        Assert.assertEquals((String)resourceBundleMessageProvider.getMessage("format_key", new Object[]{"b", "a", "c"}), (String)"Super Package Message b a c");
        resourceBundleMessageProvider = new ResourceBundleMessageProvider(localeProvider, (ResourceBundle.Control)new WebControl((ContainerResolver)new ServletContainerResolver(hTTPContext), (MVCConfiguration)configuration), actionInvocationStore);
        Assert.assertEquals((String)resourceBundleMessageProvider.getMessage("format_key", new Object[]{"b", "a", "c"}), (String)"Default Message b a c");
        EasyMock.verify((Object[])new Object[]{actionInvocationStore});
    }

    @Test
    public void missing() {
        HTTPContext hTTPContext = new HTTPContext(Path.of("src/test/java", new String[0]));
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/l10n/Test", null, actionConfiguration)).times(2);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        LocaleProvider localeProvider = (LocaleProvider)EasyMock.createStrictMock(LocaleProvider.class);
        EasyMock.expect((Object)((Locale)localeProvider.get())).andReturn((Object)Locale.US).anyTimes();
        EasyMock.replay((Object[])new Object[]{localeProvider});
        ResourceBundleMessageProvider resourceBundleMessageProvider = new ResourceBundleMessageProvider(localeProvider, (ResourceBundle.Control)new WebControl((ContainerResolver)new ServletContainerResolver(hTTPContext), (MVCConfiguration)configuration), actionInvocationStore);
        try {
            resourceBundleMessageProvider.getMessage("bad_key", new Object[0]);
            Assert.fail((String)"Should have failed");
        }
        catch (MissingMessageException missingMessageException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{actionInvocationStore});
    }

    @Test
    public void noActionInvocation() {
        HTTPContext hTTPContext = new HTTPContext(Path.of("src/test/java", new String[0]));
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn(null).times(3);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        LocaleProvider localeProvider = (LocaleProvider)EasyMock.createStrictMock(LocaleProvider.class);
        EasyMock.expect((Object)((Locale)localeProvider.get())).andReturn((Object)Locale.US).anyTimes();
        EasyMock.replay((Object[])new Object[]{localeProvider});
        ResourceBundleMessageProvider resourceBundleMessageProvider = new ResourceBundleMessageProvider(localeProvider, (ResourceBundle.Control)new WebControl((ContainerResolver)new ServletContainerResolver(hTTPContext), (MVCConfiguration)configuration), actionInvocationStore);
        Assert.assertEquals((String)resourceBundleMessageProvider.getMessage("[blank]foo.bar", new Object[0]), (String)"Required");
        try {
            resourceBundleMessageProvider.getMessage("[not_found]bar", new Object[0]);
            Assert.fail((String)"Should have failed");
        }
        catch (MissingMessageException missingMessageException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{actionInvocationStore});
    }

    @Test
    public void search() {
        HTTPContext hTTPContext = new HTTPContext(Path.of("src/test/java", new String[0]));
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/l10n/Test", null, actionConfiguration));
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/l10n/NonExistent", null, actionConfiguration));
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/badPackage/Test", null, actionConfiguration));
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/l10n/Test", null, actionConfiguration));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        LocaleProvider localeProvider = (LocaleProvider)EasyMock.createStrictMock(LocaleProvider.class);
        EasyMock.expect((Object)((Locale)localeProvider.get())).andReturn((Object)Locale.US).times(9);
        EasyMock.expect((Object)((Locale)localeProvider.get())).andReturn((Object)Locale.GERMAN).times(3);
        EasyMock.replay((Object[])new Object[]{localeProvider});
        ResourceBundleMessageProvider resourceBundleMessageProvider = new ResourceBundleMessageProvider(localeProvider, (ResourceBundle.Control)new WebControl((ContainerResolver)new ServletContainerResolver(hTTPContext), (MVCConfiguration)configuration), actionInvocationStore);
        Assert.assertEquals((String)resourceBundleMessageProvider.getMessage("key", new Object[0]), (String)"American English Message");
        Assert.assertEquals((String)resourceBundleMessageProvider.getMessage("key", new Object[0]), (String)"Package Message");
        Assert.assertEquals((String)resourceBundleMessageProvider.getMessage("key", new Object[0]), (String)"Super Package Message");
        resourceBundleMessageProvider = new ResourceBundleMessageProvider(localeProvider, (ResourceBundle.Control)new WebControl((ContainerResolver)new ServletContainerResolver(hTTPContext), (MVCConfiguration)configuration), actionInvocationStore);
        Assert.assertEquals((String)resourceBundleMessageProvider.getMessage("key", new Object[0]), (String)"Default Message");
        EasyMock.verify((Object[])new Object[]{actionInvocationStore});
    }
}

