/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.message;

import io.fusionauth.http.server.HTTPRequest;
import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.primeframework.mvc.message.DefaultMessageStore;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleFieldMessage;
import org.primeframework.mvc.message.SimpleMessage;
import org.primeframework.mvc.message.scope.ApplicationScope;
import org.primeframework.mvc.message.scope.FlashScope;
import org.primeframework.mvc.message.scope.MessageScope;
import org.primeframework.mvc.message.scope.RequestScope;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultMessageStoreTest {
    @Test
    public void bulk() {
        ArrayList<SimpleFieldMessage> arrayList = new ArrayList<SimpleFieldMessage>();
        arrayList.add(new SimpleFieldMessage(MessageType.ERROR, "foo.bar", "code", "message"));
        arrayList.add(new SimpleFieldMessage(MessageType.ERROR, "foo.baz", "code", "message"));
        RequestScope requestScope = (RequestScope)EasyMock.createStrictMock(RequestScope.class);
        requestScope.addAll(arrayList);
        EasyMock.replay((Object[])new Object[]{requestScope});
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        DefaultMessageStore defaultMessageStore = new DefaultMessageStore(null, null, requestScope, hTTPRequest);
        defaultMessageStore.addAll(MessageScope.REQUEST, arrayList);
        EasyMock.verify((Object[])new Object[]{requestScope});
    }

    @Test
    public void get() {
        ArrayList<SimpleMessage> arrayList = new ArrayList<SimpleMessage>();
        arrayList.add(new SimpleMessage(MessageType.ERROR, "code1", "request1"));
        arrayList.add(new SimpleMessage(MessageType.ERROR, "code2", "request2"));
        ArrayList<SimpleMessage> arrayList2 = new ArrayList<SimpleMessage>();
        arrayList2.add(new SimpleMessage(MessageType.ERROR, "code3", "flash1"));
        arrayList2.add(new SimpleMessage(MessageType.ERROR, "code4", "flash2"));
        ArrayList<SimpleMessage> arrayList3 = new ArrayList<SimpleMessage>();
        arrayList3.add(new SimpleMessage(MessageType.ERROR, "code7", "application1"));
        arrayList3.add(new SimpleMessage(MessageType.ERROR, "code8", "application2"));
        RequestScope requestScope = (RequestScope)EasyMock.createStrictMock(RequestScope.class);
        EasyMock.expect((Object)requestScope.get()).andReturn(arrayList);
        EasyMock.replay((Object[])new Object[]{requestScope});
        FlashScope flashScope = (FlashScope)EasyMock.createStrictMock(FlashScope.class);
        EasyMock.expect((Object)flashScope.get()).andReturn(arrayList2);
        EasyMock.replay((Object[])new Object[]{flashScope});
        ApplicationScope applicationScope = (ApplicationScope)EasyMock.createStrictMock(ApplicationScope.class);
        EasyMock.expect((Object)applicationScope.get()).andReturn(arrayList3);
        EasyMock.replay((Object[])new Object[]{applicationScope});
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        DefaultMessageStore defaultMessageStore = new DefaultMessageStore(applicationScope, flashScope, requestScope, hTTPRequest);
        List list = defaultMessageStore.get();
        Assert.assertEquals((int)list.size(), (int)6);
        int n = 0;
        Assert.assertEquals((String)((Message)list.get(n++)).toString(), (String)"request1");
        Assert.assertEquals((String)((Message)list.get(n++)).toString(), (String)"request2");
        Assert.assertEquals((String)((Message)list.get(n++)).toString(), (String)"flash1");
        Assert.assertEquals((String)((Message)list.get(n++)).toString(), (String)"flash2");
        Assert.assertEquals((String)((Message)list.get(n++)).toString(), (String)"application1");
        Assert.assertEquals((String)((Message)list.get(n)).toString(), (String)"application2");
        EasyMock.verify((Object[])new Object[]{requestScope, flashScope, applicationScope});
    }

    @Test
    public void getScope() {
        ArrayList<SimpleMessage> arrayList = new ArrayList<SimpleMessage>();
        arrayList.add(new SimpleMessage(MessageType.ERROR, "code1", "request1"));
        arrayList.add(new SimpleMessage(MessageType.ERROR, "code2", "request2"));
        RequestScope requestScope = (RequestScope)EasyMock.createStrictMock(RequestScope.class);
        EasyMock.expect((Object)requestScope.get()).andReturn(arrayList);
        EasyMock.replay((Object[])new Object[]{requestScope});
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        DefaultMessageStore defaultMessageStore = new DefaultMessageStore(null, null, requestScope, hTTPRequest);
        List list = defaultMessageStore.get(MessageScope.REQUEST);
        Assert.assertEquals((int)list.size(), (int)2);
        int n = 0;
        Assert.assertEquals((String)((Message)list.get(n++)).toString(), (String)"request1");
        Assert.assertEquals((String)((Message)list.get(n)).toString(), (String)"request2");
        EasyMock.verify((Object[])new Object[]{requestScope});
    }

    @Test
    public void request() {
        SimpleFieldMessage simpleFieldMessage = new SimpleFieldMessage(MessageType.ERROR, "foo.bar", "code", "message");
        RequestScope requestScope = (RequestScope)EasyMock.createStrictMock(RequestScope.class);
        requestScope.add((Message)simpleFieldMessage);
        EasyMock.replay((Object[])new Object[]{requestScope});
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        DefaultMessageStore defaultMessageStore = new DefaultMessageStore(null, null, requestScope, hTTPRequest);
        defaultMessageStore.add((Message)simpleFieldMessage);
        EasyMock.verify((Object[])new Object[]{requestScope});
    }

    @Test
    public void scoped() {
        SimpleFieldMessage simpleFieldMessage = new SimpleFieldMessage(MessageType.ERROR, "foo.bar", "code", "message");
        FlashScope flashScope = (FlashScope)EasyMock.createStrictMock(FlashScope.class);
        flashScope.add((Message)simpleFieldMessage);
        EasyMock.replay((Object[])new Object[]{flashScope});
        HTTPRequest hTTPRequest = (HTTPRequest)EasyMock.createStrictMock(HTTPRequest.class);
        DefaultMessageStore defaultMessageStore = new DefaultMessageStore(null, flashScope, null, hTTPRequest);
        defaultMessageStore.add(MessageScope.FLASH, (Message)simpleFieldMessage);
        EasyMock.verify((Object[])new Object[]{flashScope});
    }
}

