/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import io.fusionauth.http.server.HTTPResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.easymock.EasyMock;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.result.StatusResult;
import org.primeframework.mvc.action.result.annotation.Status;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.scope.MessageScope;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StatusResultTest
extends PrimeBaseTest {
    @Test
    public void expansion() throws IOException {
        Object object = new Object();
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        EasyMock.expect((Object)expressionEvaluator.expand("someFieldName", object, false)).andReturn((Object)"200");
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        HTTPResponse hTTPResponse = new HTTPResponse();
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(object, null, "/foo", "", null));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        ArrayList arrayList = new ArrayList();
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.expect((Object)messageStore.get(MessageScope.REQUEST)).andReturn(arrayList);
        messageStore.clear(MessageScope.REQUEST);
        messageStore.addAll(MessageScope.FLASH, arrayList);
        EasyMock.replay((Object[])new Object[]{messageStore});
        StatusImpl statusImpl = new StatusImpl("success", 200, "someFieldName", new Status.Header[0]);
        StatusResult statusResult = new StatusResult(expressionEvaluator, hTTPResponse, actionInvocationStore);
        statusResult.execute((Status)statusImpl);
        Assert.assertEquals((int)hTTPResponse.getStatus(), (int)200);
        Assert.assertEquals((String)hTTPResponse.getHeader("Cache-Control"), (String)"no-cache");
    }

    @Test
    public void headers() throws IOException {
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        HTTPResponse hTTPResponse = new HTTPResponse();
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/foo", "", null));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        ArrayList arrayList = new ArrayList();
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.expect((Object)messageStore.get(MessageScope.REQUEST)).andReturn(arrayList);
        messageStore.clear(MessageScope.REQUEST);
        messageStore.addAll(MessageScope.FLASH, arrayList);
        EasyMock.replay((Object[])new Object[]{messageStore});
        StatusImpl statusImpl = new StatusImpl("success", 200, "", new HeaderImpl("foo", "bar"), new HeaderImpl("baz", "fred"));
        StatusResult statusResult = new StatusResult(expressionEvaluator, hTTPResponse, actionInvocationStore);
        statusResult.execute((Status)statusImpl);
        Assert.assertEquals((int)hTTPResponse.getStatus(), (int)200);
        Assert.assertEquals((String)hTTPResponse.getHeader("foo"), (String)"bar");
        Assert.assertEquals((String)hTTPResponse.getHeader("baz"), (String)"fred");
        Assert.assertEquals((String)hTTPResponse.getHeader("Cache-Control"), (String)"no-cache");
    }

    @Test
    public void noHeaders() throws IOException {
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        HTTPResponse hTTPResponse = new HTTPResponse();
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/foo", "", null));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        ArrayList arrayList = new ArrayList();
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.expect((Object)messageStore.get(MessageScope.REQUEST)).andReturn(arrayList);
        messageStore.clear(MessageScope.REQUEST);
        messageStore.addAll(MessageScope.FLASH, arrayList);
        EasyMock.replay((Object[])new Object[]{messageStore});
        StatusImpl statusImpl = new StatusImpl("success", 200, "", new Status.Header[0]);
        StatusResult statusResult = new StatusResult(expressionEvaluator, hTTPResponse, actionInvocationStore);
        statusResult.execute((Status)statusImpl);
        Assert.assertEquals((int)hTTPResponse.getStatus(), (int)200);
        Assert.assertEquals((String)hTTPResponse.getHeader("Cache-Control"), (String)"no-cache");
    }

    public static class StatusImpl
    implements Status {
        private final String cacheControl;
        private final String code;
        private final boolean disableCacheControl;
        private final Status.Header[] headers;
        private final int status;
        private final String statusStr;

        public StatusImpl(String string, int n, String string2, Status.Header ... headerArray) {
            this.cacheControl = "no-cache";
            this.code = string;
            this.disableCacheControl = false;
            this.headers = headerArray;
            this.status = n;
            this.statusStr = string2;
        }

        public Class<? extends Annotation> annotationType() {
            return Status.class;
        }

        public String cacheControl() {
            return this.cacheControl;
        }

        public String code() {
            return this.code;
        }

        public boolean disableCacheControl() {
            return this.disableCacheControl;
        }

        public Status.Header[] headers() {
            return this.headers;
        }

        public int status() {
            return this.status;
        }

        public String statusStr() {
            return this.statusStr;
        }
    }

    public static class HeaderImpl
    implements Status.Header {
        private final String name;
        private final String value;

        public HeaderImpl(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public Class<? extends Annotation> annotationType() {
            return Status.Header.class;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }
    }
}

