/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.google.inject.Inject;
import io.fusionauth.jwt.InvalidJWTException;
import io.fusionauth.jwt.InvalidJWTSignatureException;
import io.fusionauth.jwt.JWTException;
import io.fusionauth.jwt.JWTExpiredException;
import io.fusionauth.jwt.JWTUnavailableForProcessingException;
import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.JWT;
import java.util.Map;
import org.primeframework.mvc.security.JWTRequestAdapter;
import org.primeframework.mvc.security.JWTSecurityContext;
import org.primeframework.mvc.security.UnauthenticatedException;
import org.primeframework.mvc.security.VerifierProvider;

public class DefaultJWTSecurityContext
implements JWTSecurityContext {
    protected final JWTRequestAdapter requestAdapter;
    protected final VerifierProvider verifierProvider;

    @Inject
    public DefaultJWTSecurityContext(JWTRequestAdapter requestAdapter, VerifierProvider verifierProvider) {
        this.requestAdapter = requestAdapter;
        this.verifierProvider = verifierProvider;
    }

    @Override
    public JWT getJWT() {
        try {
            String encodedJWT = this.requestAdapter.getEncodedJWT();
            if (encodedJWT == null) {
                throw new UnauthenticatedException();
            }
            Map<String, Verifier> verifiers = this.verifierProvider.get();
            if (verifiers.isEmpty()) {
                throw new UnauthenticatedException();
            }
            return JWT.getDecoder().decode(encodedJWT, verifiers);
        }
        catch (InvalidJWTException | InvalidJWTSignatureException | JWTExpiredException | JWTUnavailableForProcessingException e) {
            this.requestAdapter.invalidateJWT();
            throw new UnauthenticatedException();
        }
        catch (JWTException e) {
            throw new UnauthenticatedException();
        }
    }
}

