/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.el;

import com.google.inject.Inject;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.ConverterProvider;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.parameter.el.Expression;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;
import org.primeframework.mvc.parameter.el.ExpressionException;

public class DefaultExpressionEvaluator
implements ExpressionEvaluator {
    private final MVCConfiguration configuration;
    private final ConverterProvider converterProvider;

    @Inject
    public DefaultExpressionEvaluator(ConverterProvider converterProvider, MVCConfiguration configuration) {
        this.converterProvider = converterProvider;
        this.configuration = configuration;
    }

    @Override
    public String expand(String str, final Object object, final boolean encode) throws ExpressionException {
        return new StrSubstitutor(new StrLookup<String>(){

            @Override
            public String lookup(String name) {
                String value = DefaultExpressionEvaluator.this.getValue(name, object, Collections.emptyMap());
                if (value == null) {
                    return "";
                }
                if (encode) {
                    value = URLEncoder.encode(value, StandardCharsets.UTF_8);
                }
                return value;
            }
        }).replace(str);
    }

    @Override
    public Collection<Object> getAllMemberValues(Object obj, Set<String> memberNames) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String name : memberNames) {
            values.add(this.getValue(name, obj));
        }
        return values;
    }

    @Override
    public <T> T getValue(String expression, Object object) throws ExpressionException {
        Expression expr = new Expression(this.converterProvider, expression, object, null, this.configuration);
        return (T)expr.traverseToEndForGet();
    }

    @Override
    public String getValue(String expression, Object object, Map<String, String> attributes) throws ExpressionException {
        Expression expr = new Expression(this.converterProvider, expression, object, attributes, this.configuration);
        Object value = expr.traverseToEndForGet();
        if (value == null) {
            return null;
        }
        return expr.getCurrentValueAsString();
    }

    @Override
    public void setValue(String expression, Object object, Object value) throws ExpressionException {
        Expression expr = new Expression(this.converterProvider, expression, object, null, this.configuration);
        expr.traverseToEndForSet();
        expr.setCurrentValue(value);
    }

    @Override
    public void setValue(String expression, Object object, String[] values, Map<String, String> attributes) throws ConversionException, ConverterStateException, ExpressionException {
        Expression expr = new Expression(this.converterProvider, expression, object, attributes, this.configuration);
        expr.traverseToEndForSet();
        expr.setCurrentValue(values);
    }
}

