/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.content.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPRequest;
import java.io.IOException;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.content.json.BaseJacksonContentHandler;
import org.primeframework.mvc.content.json.JacksonActionConfiguration;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.l10n.MessageProvider;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;

public class JacksonContentHandler
extends BaseJacksonContentHandler {
    @Inject
    public JacksonContentHandler(HTTPRequest request, ActionInvocationStore store, ObjectMapper objectMapper, ExpressionEvaluator expressionEvaluator, MessageProvider messageProvider, MessageStore messageStore) {
        super(request, store, objectMapper, expressionEvaluator, messageProvider, messageStore);
    }

    @Override
    protected void handle(Object action, Object currentValue, String contentType, JacksonActionConfiguration.RequestMember requestMember) throws IOException {
        ObjectReader reader = currentValue != null ? this.objectMapper.readerForUpdating(currentValue) : this.objectMapper.readerFor(requestMember.type);
        Object jsonObject = reader.readValue(this.request.getInputStream());
        if (currentValue == null) {
            this.expressionEvaluator.setValue(requestMember.name, action, jsonObject);
        }
    }
}

