/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.content.binary;

import java.util.Map;
import org.primeframework.mvc.action.config.ActionConfigurator;
import org.primeframework.mvc.content.binary.BinaryActionConfiguration;
import org.primeframework.mvc.content.binary.annotation.BinaryRequest;
import org.primeframework.mvc.content.binary.annotation.BinaryResponse;
import org.primeframework.mvc.util.ReflectionUtils;

public class BinaryActionConfigurator
implements ActionConfigurator {
    @Override
    public Object configure(Class<?> actionClass) {
        String responseMember;
        Map<String, BinaryRequest> binaryRequestMembers = ReflectionUtils.findAllMembersWithAnnotation(actionClass, BinaryRequest.class);
        Map<String, BinaryResponse> binaryResponseMembers = ReflectionUtils.findAllMembersWithAnnotation(actionClass, BinaryResponse.class);
        if (binaryRequestMembers.size() > 1 || binaryResponseMembers.size() > 1) {
            throw new IllegalArgumentException("Action class [" + String.valueOf(actionClass) + "] contains multiple fields with the @BinaryRequest or @BinaryResponse annotation. This annotation should only exist on a single field.");
        }
        String requestMember = binaryRequestMembers.size() == 1 ? binaryRequestMembers.keySet().iterator().next() : null;
        String string = responseMember = binaryResponseMembers.size() == 1 ? binaryResponseMembers.keySet().iterator().next() : null;
        if (requestMember != null || responseMember != null) {
            BinaryActionConfiguration configuration = new BinaryActionConfiguration(requestMember, responseMember);
            if (requestMember != null) {
                configuration.deleteRequestMemberUponCompletion = binaryRequestMembers.get(requestMember).deleteUponCompletion();
            }
            if (responseMember != null) {
                configuration.deleteResponseMemberUponCompletion = binaryResponseMembers.get(responseMember).deleteUponCompletion();
            }
            return configuration;
        }
        return null;
    }
}

