/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control.form;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.example.action.user.EditAction;
import org.example.action.user.SomeEnum;
import org.example.domain.Address;
import org.example.domain.User;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.action.config.DefaultActionConfigurationBuilder;
import org.primeframework.mvc.control.Control;
import org.primeframework.mvc.control.ControlBaseTest;
import org.primeframework.mvc.control.form.Pair;
import org.primeframework.mvc.control.form.Select;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleFieldMessage;
import org.primeframework.mvc.util.DefaultURIBuilder;
import org.primeframework.mvc.util.MapBuilder;
import org.primeframework.mvc.util.URIBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SelectTest
extends ControlBaseTest {
    private static final ActionConfiguration userEditActionConfiguration = new DefaultActionConfigurationBuilder((URIBuilder)new DefaultURIBuilder(), Set.of()).build(EditAction.class);
    @Inject
    public Select select;

    @Test
    public void action() {
        Address address = new Address();
        address.setCountry("US");
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setAddress("work", address);
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/select", null, userEditActionConfiguration));
        new ControlBaseTest.ControlTester((Control)this.select).attr("name", "user.addresses['work'].country").attr("items", MapBuilder.lmap((Object[])new String[]{"US", "United States", "DE", "Germany"})).go("<input type=\"hidden\" name=\"user.addresses[&#39;work&#39;].country@param\" value=\"param-value\"/>\n<div class=\"select input control\">\n<div class=\"label-container\"><label for=\"user_addresses[&#39;work&#39;]_country\" class=\"label\">Country</label></div>\n<div class=\"control-container\">\n<select id=\"user_addresses[&#39;work&#39;]_country\" name=\"user.addresses[&#39;work&#39;].country\">\n<option value=\"US\" selected=\"selected\">United States</option>\n<option value=\"DE\">Germany</option>\n</select>\n</div>\n</div>\n");
    }

    @Test
    public void actionLess() {
        this.ais.setCurrent(new ActionInvocation(null, null, "/select", null, userEditActionConfiguration));
        new ControlBaseTest.ControlTester((Control)this.select).attr("name", "test").attr("class", "css-class").attr("items", Arrays.asList("one", "two", "three")).go("<input type=\"hidden\" name=\"test@param\" value=\"param-value\"/>\n<div class=\"css-class-select css-class-input css-class-control select input control\">\n<div class=\"label-container\"><label for=\"test\" class=\"label\">Test</label></div>\n<div class=\"control-container\">\n<select class=\"css-class\" id=\"test\" name=\"test\">\n<option value=\"one\">one</option>\n<option value=\"two\">two</option>\n<option value=\"three\">three</option>\n</select>\n</div>\n</div>\n");
    }

    @Test
    public void enums() {
        EditAction editAction = new EditAction();
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/select", null, userEditActionConfiguration));
        new ControlBaseTest.ControlTester((Control)this.select).attr("name", "enumValue").attr("items", SomeEnum.values()).go("<input type=\"hidden\" name=\"enumValue@param\" value=\"param-value\"/>\n<div class=\"select input control\">\n<div class=\"label-container\"><label for=\"enumValue\" class=\"label\">Enum</label></div>\n<div class=\"control-container\">\n<select id=\"enumValue\" name=\"enumValue\">\n<option value=\"VALUE1\" selected=\"selected\">Value 1</option>\n<option value=\"VALUE2\">Value 2</option>\n<option value=\"VALUE3\">VALUE3</option>\n</select>\n</div>\n</div>\n");
    }

    @Test
    public void expressions() {
        Address address = new Address();
        address.setCountry("US");
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setAddress("work", address);
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/select", null, userEditActionConfiguration));
        Pair pair = new Pair("US", "United States");
        Pair pair2 = new Pair("DE", "Germany");
        new ControlBaseTest.ControlTester((Control)this.select).attr("name", "user.addresses['work'].country").attr("valueExpr", "left").attr("textExpr", "right").attr("items", ArrayUtils.toArray((Object[])new Pair[]{pair, pair2})).go("<input type=\"hidden\" name=\"user.addresses[&#39;work&#39;].country@param\" value=\"param-value\"/>\n<div class=\"select input control\">\n<div class=\"label-container\"><label for=\"user_addresses[&#39;work&#39;]_country\" class=\"label\">Country</label></div>\n<div class=\"control-container\">\n<select id=\"user_addresses[&#39;work&#39;]_country\" name=\"user.addresses[&#39;work&#39;].country\">\n<option value=\"US\" selected=\"selected\">United States</option>\n<option value=\"DE\">Germany</option>\n</select>\n</div>\n</div>\n");
    }

    @Test
    public void fieldErrors() {
        Address address = new Address();
        address.setCountry("US");
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setAddress("work", address);
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/select", null, userEditActionConfiguration));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "user.addresses['work'].country", "code1", "fieldError1"));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "user.addresses['work'].country", "code2", "fieldError2"));
        new ControlBaseTest.ControlTester((Control)this.select).attr("name", "user.addresses['work'].country").attr("items", MapBuilder.lmap((Object[])new String[]{"US", "United States", "DE", "Germany"})).go("<input type=\"hidden\" name=\"user.addresses[&#39;work&#39;].country@param\" value=\"param-value\"/>\n<div class=\"select input control\">\n<div class=\"label-container\"><label for=\"user_addresses[&#39;work&#39;]_country\" class=\"label\"><span class=\"error\">Country (fieldError1, fieldError2)</span></label></div>\n<div class=\"control-container\">\n<select id=\"user_addresses[&#39;work&#39;]_country\" name=\"user.addresses[&#39;work&#39;].country\">\n<option value=\"US\" selected=\"selected\">United States</option>\n<option value=\"DE\">Germany</option>\n</select>\n</div>\n</div>\n");
    }

    @Test
    public void headerOption() {
        this.ais.setCurrent(new ActionInvocation(null, null, "/select", null, userEditActionConfiguration));
        new ControlBaseTest.ControlTester((Control)this.select).attr("name", "test").attr("headerValue", "zero").attr("items", Arrays.asList("one", "two", "three")).go("<input type=\"hidden\" name=\"test@param\" value=\"param-value\"/>\n<div class=\"select input control\">\n<div class=\"label-container\"><label for=\"test\" class=\"label\">Test</label></div>\n<div class=\"control-container\">\n<select id=\"test\" name=\"test\">\n<option value=\"zero\"></option>\n<option value=\"one\">one</option>\n<option value=\"two\">two</option>\n<option value=\"three\">three</option>\n</select>\n</div>\n</div>\n");
    }

    @Test
    public void html() {
        Address address = new Address();
        address.setCountry("<US>");
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setAddress("work", address);
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/select", null, userEditActionConfiguration));
        new ControlBaseTest.ControlTester((Control)this.select).attr("name", "user.addresses['work'].country").attr("items", MapBuilder.lmap((Object[])new String[]{"<US>", "<United States>", "DE", "Germany"})).go("<input type=\"hidden\" name=\"user.addresses[&#39;work&#39;].country@param\" value=\"param-value\"/>\n<div class=\"select input control\">\n<div class=\"label-container\"><label for=\"user_addresses[&#39;work&#39;]_country\" class=\"label\">Country</label></div>\n<div class=\"control-container\">\n<select id=\"user_addresses[&#39;work&#39;]_country\" name=\"user.addresses[&#39;work&#39;].country\">\n<option value=\"&lt;US&gt;\" selected=\"selected\">&lt;United States&gt;</option>\n<option value=\"DE\">Germany</option>\n</select>\n</div>\n</div>\n");
    }

    @Test
    public void optionalAttributeValidationFailure() {
        Address address = new Address();
        address.setCountry("US");
        EditAction editAction = new EditAction();
        editAction.user = new User();
        editAction.user.setAddress("work", address);
        this.ais.setCurrent(new ActionInvocation((Object)editAction, null, "/select", null, userEditActionConfiguration));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "user.addresses['work'].country", "code1", "fieldError1"));
        this.messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "user.addresses['work'].country", "code2", "fieldError2"));
        try {
            new ControlBaseTest.ControlTester((Control)this.select).attr("name", "user.addresses['work'].country").attr("items", MapBuilder.lmap((Object[])new String[]{"US", "United States", "DE", "Germany"})).attr("multiple", "multiple").go(null);
            Assert.fail((String)"Should have failed because the multiple attribute should be a boolean");
        }
        catch (PrimeException primeException) {
            Assert.assertTrue((boolean)primeException.getMessage().contains("multiple"));
        }
    }
}

