/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.content.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import org.easymock.EasyMock;
import org.example.action.KitchenSinkAction;
import org.example.domain.UserField;
import org.example.domain.UserType;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.ExecuteMethodConfiguration;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.content.json.JacksonActionConfiguration;
import org.primeframework.mvc.content.json.JacksonContentHandler;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleFieldMessage;
import org.primeframework.mvc.message.SimpleMessage;
import org.primeframework.mvc.message.l10n.MessageProvider;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;
import org.primeframework.mvc.validation.ValidationException;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class JacksonContentHandlerTest
extends PrimeBaseTest {
    @Inject
    public ExpressionEvaluator expressionEvaluator;

    @DataProvider(name="trueFalse")
    private static Object[][] getTrueFalse() {
        return new Object[][]{{true}, {false}};
    }

    @Test(dataProvider="trueFalse")
    public void enum_values(boolean bl) throws IOException {
        HashMap<Class<JacksonActionConfiguration>, JacksonActionConfiguration> hashMap = new HashMap<Class<JacksonActionConfiguration>, JacksonActionConfiguration>();
        HashMap<HTTPMethod, JacksonActionConfiguration.RequestMember> hashMap2 = new HashMap<HTTPMethod, JacksonActionConfiguration.RequestMember>();
        hashMap2.put(HTTPMethod.POST, new JacksonActionConfiguration.RequestMember("jsonRequest", UserField.class));
        hashMap.put(JacksonActionConfiguration.class, new JacksonActionConfiguration(hashMap2, null, null));
        KitchenSinkAction kitchenSinkAction = new KitchenSinkAction(null);
        ActionConfiguration actionConfiguration = new ActionConfiguration(KitchenSinkAction.class, false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Collections.emptyList(), null, hashMap, null, null, null, null, null);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation((Object)kitchenSinkAction, new ExecuteMethodConfiguration(HTTPMethod.POST, null, null), "/action", null, actionConfiguration));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        String string = bl ? "{\n  \"nested\": {\n    \"fruit\": \"bar\"\n  }\n}\n" : "{\n  \"fruit\": \"foo\"\n}\n";
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.setInputStream((InputStream)new ByteArrayInputStream(string.getBytes()));
        hTTPRequest.setContentLength(Long.valueOf(string.getBytes().length));
        hTTPRequest.setContentType("application/json");
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.expect((Object)messageProvider.getMessage((String)EasyMock.eq((Object)(bl ? "[invalid]nested.fruit" : "[invalid]fruit")), new Object[]{EasyMock.eq((Object)(bl ? "bar" : "foo")), EasyMock.eq((Object)"Apple, Orange")})).andReturn((Object)"Bad value");
        EasyMock.replay((Object[])new Object[]{messageProvider});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, bl ? "nested.fruit" : "fruit", bl ? "[invalid]nested.fruit" : "[invalid]fruit", "Bad value"));
        EasyMock.replay((Object[])new Object[]{messageStore});
        JacksonContentHandler jacksonContentHandler = new JacksonContentHandler(hTTPRequest, actionInvocationStore, new ObjectMapper(), this.expressionEvaluator, messageProvider, messageStore);
        try {
            jacksonContentHandler.handle();
            Assert.fail((String)"Should have thrown");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        Assert.assertNull((Object)kitchenSinkAction.jsonRequest);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, messageProvider, messageStore});
    }

    @Test
    public void handle() throws IOException {
        HashMap<Class<JacksonActionConfiguration>, JacksonActionConfiguration> hashMap = new HashMap<Class<JacksonActionConfiguration>, JacksonActionConfiguration>();
        HashMap<HTTPMethod, JacksonActionConfiguration.RequestMember> hashMap2 = new HashMap<HTTPMethod, JacksonActionConfiguration.RequestMember>();
        hashMap2.put(HTTPMethod.POST, new JacksonActionConfiguration.RequestMember("jsonRequest", UserField.class));
        hashMap.put(JacksonActionConfiguration.class, new JacksonActionConfiguration(hashMap2, null, null));
        KitchenSinkAction kitchenSinkAction = new KitchenSinkAction(null);
        ActionConfiguration actionConfiguration = new ActionConfiguration(KitchenSinkAction.class, false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, hashMap, null, null, null, null, null);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation((Object)kitchenSinkAction, new ExecuteMethodConfiguration(HTTPMethod.POST, null, null), "/action", null, actionConfiguration));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        String string = "{  \"active\":true,  \"addresses\":{    \"home\":{      \"city\":\"Broomfield\",      \"state\":\"Colorado\",      \"zipcode\":\"80023\"    },    \"work\":{      \"city\":\"Denver\",      \"state\":\"Colorado\",      \"zipcode\":\"80202\"    }  },  \"age\":37,  \"favoriteMonth\":5,  \"favoriteYear\":1976,  \"ids\":{    \"0\":1,    \"1\":2  },  \"lifeStory\":\"Hello world\",  \"securityQuestions\":[\"one\",\"two\",\"three\",\"four\"],  \"siblings\":[{    \"active\":false,    \"name\":\"Brett\"  },{    \"active\":false,    \"name\":\"Beth\"  }],  \"type\":\"COOL\"}";
        this.request.setInputStream((InputStream)new ByteArrayInputStream(string.getBytes()));
        this.request.setContentLength(Long.valueOf(string.getBytes().length));
        this.request.setContentType("application/json");
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.replay((Object[])new Object[]{messageProvider});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.replay((Object[])new Object[]{messageStore});
        JacksonContentHandler jacksonContentHandler = new JacksonContentHandler(this.request, actionInvocationStore, new ObjectMapper(), this.expressionEvaluator, messageProvider, messageStore);
        jacksonContentHandler.handle();
        Assert.assertEquals((String)kitchenSinkAction.jsonRequest.addresses.get((Object)"work").city, (String)"Denver");
        Assert.assertEquals((String)kitchenSinkAction.jsonRequest.addresses.get((Object)"work").state, (String)"Colorado");
        Assert.assertEquals((String)kitchenSinkAction.jsonRequest.addresses.get((Object)"work").zipcode, (String)"80202");
        Assert.assertEquals((String)kitchenSinkAction.jsonRequest.addresses.get((Object)"home").city, (String)"Broomfield");
        Assert.assertEquals((String)kitchenSinkAction.jsonRequest.addresses.get((Object)"home").state, (String)"Colorado");
        Assert.assertEquals((String)kitchenSinkAction.jsonRequest.addresses.get((Object)"home").zipcode, (String)"80023");
        Assert.assertTrue((boolean)kitchenSinkAction.jsonRequest.active);
        Assert.assertEquals((int)kitchenSinkAction.jsonRequest.age, (int)37);
        Assert.assertEquals((int)kitchenSinkAction.jsonRequest.favoriteMonth, (int)5);
        Assert.assertEquals((int)kitchenSinkAction.jsonRequest.favoriteYear, (int)1976);
        Assert.assertEquals((int)kitchenSinkAction.jsonRequest.ids.get(0), (int)1);
        Assert.assertEquals((int)kitchenSinkAction.jsonRequest.ids.get(1), (int)2);
        Assert.assertEquals((String)kitchenSinkAction.jsonRequest.lifeStory, (String)"Hello world");
        Assert.assertEquals((Object[])kitchenSinkAction.jsonRequest.securityQuestions, (Object[])new String[]{"one", "two", "three", "four"});
        Assert.assertEquals((String)kitchenSinkAction.jsonRequest.siblings.get((int)0).name, (String)"Brett");
        Assert.assertEquals((String)kitchenSinkAction.jsonRequest.siblings.get((int)1).name, (String)"Beth");
        Assert.assertEquals((Object)((Object)kitchenSinkAction.jsonRequest.type), (Object)((Object)UserType.COOL));
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, messageProvider, messageStore});
    }

    @Test
    public void handleBadInArray() throws IOException {
        HashMap<Class<JacksonActionConfiguration>, JacksonActionConfiguration> hashMap = new HashMap<Class<JacksonActionConfiguration>, JacksonActionConfiguration>();
        HashMap<HTTPMethod, JacksonActionConfiguration.RequestMember> hashMap2 = new HashMap<HTTPMethod, JacksonActionConfiguration.RequestMember>();
        hashMap2.put(HTTPMethod.POST, new JacksonActionConfiguration.RequestMember("jsonRequest", UserField.class));
        hashMap.put(JacksonActionConfiguration.class, new JacksonActionConfiguration(hashMap2, null, null));
        KitchenSinkAction kitchenSinkAction = new KitchenSinkAction(null);
        ActionConfiguration actionConfiguration = new ActionConfiguration(KitchenSinkAction.class, false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Collections.emptyList(), null, hashMap, null, null, null, null, null);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation((Object)kitchenSinkAction, new ExecuteMethodConfiguration(HTTPMethod.POST, null, null), "/action", null, actionConfiguration));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        String string = "{  \"siblings\":[{    \"age\":\"old\"  }]}";
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.setInputStream((InputStream)new ByteArrayInputStream(string.getBytes()));
        hTTPRequest.setContentLength(Long.valueOf(string.getBytes().length));
        hTTPRequest.setContentType("application/json");
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.expect((Object)messageProvider.getMessage((String)EasyMock.eq((Object)"[invalidJSON]"), new Object[]{EasyMock.eq((Object)"siblings.age"), EasyMock.eq((Object)"Possible conversion error"), EasyMock.isA(String.class)})).andReturn((Object)"Bad sibling age");
        EasyMock.replay((Object[])new Object[]{messageProvider});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "siblings.age", "[invalidJSON]", "Bad sibling age"));
        EasyMock.replay((Object[])new Object[]{messageStore});
        JacksonContentHandler jacksonContentHandler = new JacksonContentHandler(hTTPRequest, actionInvocationStore, new ObjectMapper(), this.expressionEvaluator, messageProvider, messageStore);
        try {
            jacksonContentHandler.handle();
            Assert.fail((String)"Should have thrown");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        Assert.assertNull((Object)kitchenSinkAction.jsonRequest);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, messageProvider, messageStore});
    }

    @Test
    public void handleBadInMap() throws IOException {
        HashMap<Class<JacksonActionConfiguration>, JacksonActionConfiguration> hashMap = new HashMap<Class<JacksonActionConfiguration>, JacksonActionConfiguration>();
        HashMap<HTTPMethod, JacksonActionConfiguration.RequestMember> hashMap2 = new HashMap<HTTPMethod, JacksonActionConfiguration.RequestMember>();
        hashMap2.put(HTTPMethod.POST, new JacksonActionConfiguration.RequestMember("jsonRequest", UserField.class));
        hashMap.put(JacksonActionConfiguration.class, new JacksonActionConfiguration(hashMap2, null, null));
        KitchenSinkAction kitchenSinkAction = new KitchenSinkAction(null);
        ActionConfiguration actionConfiguration = new ActionConfiguration(KitchenSinkAction.class, false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Collections.emptyList(), null, hashMap, null, null, null, null, null);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation((Object)kitchenSinkAction, new ExecuteMethodConfiguration(HTTPMethod.POST, null, null), "/action", null, actionConfiguration));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        String string = "{  \"addresses\":{    \"home\":{      \"age\":\"old\"    }  }}";
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.setInputStream((InputStream)new ByteArrayInputStream(string.getBytes()));
        hTTPRequest.setContentLength(Long.valueOf(string.getBytes().length));
        hTTPRequest.setContentType("application/json");
        MessageProvider messageProvider = (MessageProvider)EasyMock.createNiceMock(MessageProvider.class);
        EasyMock.expect((Object)messageProvider.getMessage((String)EasyMock.eq((Object)"[invalidJSON]"), new Object[]{EasyMock.eq((Object)"addresses.home.age"), EasyMock.eq((Object)"Possible conversion error"), EasyMock.isA(String.class)})).andReturn((Object)"Bad age");
        EasyMock.replay((Object[])new Object[]{messageProvider});
        MessageStore messageStore = (MessageStore)EasyMock.createNiceMock(MessageStore.class);
        messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "addresses.home.age", "[invalidJSON]", "Bad age"));
        EasyMock.replay((Object[])new Object[]{messageStore});
        JacksonContentHandler jacksonContentHandler = new JacksonContentHandler(hTTPRequest, actionInvocationStore, new ObjectMapper(), this.expressionEvaluator, messageProvider, messageStore);
        try {
            jacksonContentHandler.handle();
            Assert.fail((String)"Should have thrown");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        Assert.assertNull((Object)kitchenSinkAction.jsonRequest);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, messageProvider, messageStore});
    }

    @Test
    public void handleBadJSON() throws IOException {
        HashMap<Class<JacksonActionConfiguration>, JacksonActionConfiguration> hashMap = new HashMap<Class<JacksonActionConfiguration>, JacksonActionConfiguration>();
        HashMap<HTTPMethod, JacksonActionConfiguration.RequestMember> hashMap2 = new HashMap<HTTPMethod, JacksonActionConfiguration.RequestMember>();
        hashMap2.put(HTTPMethod.POST, new JacksonActionConfiguration.RequestMember("jsonRequest", UserField.class));
        hashMap.put(JacksonActionConfiguration.class, new JacksonActionConfiguration(hashMap2, null, null));
        KitchenSinkAction kitchenSinkAction = new KitchenSinkAction(null);
        ActionConfiguration actionConfiguration = new ActionConfiguration(KitchenSinkAction.class, false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Collections.emptyList(), null, hashMap, null, null, null, null, null);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation((Object)kitchenSinkAction, new ExecuteMethodConfiguration(HTTPMethod.POST, null, null), "/action", null, actionConfiguration));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        String string = "{  \"bad-active\":true}";
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.setInputStream((InputStream)new ByteArrayInputStream(string.getBytes()));
        hTTPRequest.setContentLength(Long.valueOf(string.getBytes().length));
        hTTPRequest.setContentType("application/json");
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.expect((Object)messageProvider.getMessage((String)EasyMock.eq((Object)"[invalidJSON]"), new Object[]{EasyMock.eq((Object)"bad-active"), EasyMock.eq((Object)"Unrecognized property"), EasyMock.isA(String.class)})).andReturn((Object)"foo");
        EasyMock.replay((Object[])new Object[]{messageProvider});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        messageStore.add((Message)new SimpleMessage(MessageType.ERROR, "[invalidJSON]", "foo"));
        EasyMock.replay((Object[])new Object[]{messageStore});
        JacksonContentHandler jacksonContentHandler = new JacksonContentHandler(hTTPRequest, actionInvocationStore, new ObjectMapper(), this.expressionEvaluator, messageProvider, messageStore);
        try {
            jacksonContentHandler.handle();
            Assert.fail((String)"Should have thrown");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        Assert.assertNull((Object)kitchenSinkAction.jsonRequest);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, messageProvider, messageStore});
    }

    @Test
    public void handleBadRoot() throws IOException {
        HashMap<Class<JacksonActionConfiguration>, JacksonActionConfiguration> hashMap = new HashMap<Class<JacksonActionConfiguration>, JacksonActionConfiguration>();
        HashMap<HTTPMethod, JacksonActionConfiguration.RequestMember> hashMap2 = new HashMap<HTTPMethod, JacksonActionConfiguration.RequestMember>();
        hashMap2.put(HTTPMethod.POST, new JacksonActionConfiguration.RequestMember("jsonRequest", UserField.class));
        hashMap.put(JacksonActionConfiguration.class, new JacksonActionConfiguration(hashMap2, null, null));
        KitchenSinkAction kitchenSinkAction = new KitchenSinkAction(null);
        ActionConfiguration actionConfiguration = new ActionConfiguration(KitchenSinkAction.class, false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Collections.emptyList(), null, hashMap, null, null, null, null, null);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation((Object)kitchenSinkAction, new ExecuteMethodConfiguration(HTTPMethod.POST, null, null), "/action", null, actionConfiguration));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        String string = "{  \"active\":\"bad\"}";
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.setInputStream((InputStream)new ByteArrayInputStream(string.getBytes()));
        hTTPRequest.setContentLength(Long.valueOf(string.getBytes().length));
        hTTPRequest.setContentType("application/json");
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.expect((Object)messageProvider.getMessage((String)EasyMock.eq((Object)"[invalidJSON]"), new Object[]{EasyMock.eq((Object)"active"), EasyMock.eq((Object)"Possible conversion error"), EasyMock.isA(String.class)})).andReturn((Object)"Bad active");
        EasyMock.replay((Object[])new Object[]{messageProvider});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        messageStore.add((Message)new SimpleFieldMessage(MessageType.ERROR, "active", "[invalidJSON]", "Bad active"));
        EasyMock.replay((Object[])new Object[]{messageStore});
        JacksonContentHandler jacksonContentHandler = new JacksonContentHandler(hTTPRequest, actionInvocationStore, new ObjectMapper(), this.expressionEvaluator, messageProvider, messageStore);
        try {
            jacksonContentHandler.handle();
            Assert.fail((String)"Should have thrown");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        Assert.assertNull((Object)kitchenSinkAction.jsonRequest);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, messageProvider, messageStore});
    }

    @Test
    public void handleNoAction() throws IOException {
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/action", null, null));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        String string = "{  \"active\":true,  \"addresses\":{    \"home\":{      \"city\":\"Broomfield\",      \"state\":\"Colorado\",      \"zipcode\":\"80023\"    },    \"work\":{      \"city\":\"Denver\",      \"state\":\"Colorado\",      \"zipcode\":\"80202\"    }  },  \"age\":37,  \"favoriteMonth\":5,  \"favoriteYear\":1976,  \"ids\":{    \"0\":1,    \"1\":2  },  \"lifeStory\":\"Hello world\",  \"securityQuestions\":[\"one\",\"two\",\"three\",\"four\"],  \"siblings\":[{    \"active\":false,    \"name\":\"Brett\"  },{    \"active\":false,    \"name\":\"Beth\"  }],  \"type\":\"COOL\"}";
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.setInputStream((InputStream)new ByteArrayInputStream(string.getBytes()));
        hTTPRequest.setContentLength(Long.valueOf(string.getBytes().length));
        hTTPRequest.setContentType("application/json");
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.replay((Object[])new Object[]{messageProvider});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.replay((Object[])new Object[]{messageStore});
        JacksonContentHandler jacksonContentHandler = new JacksonContentHandler(hTTPRequest, actionInvocationStore, new ObjectMapper(), this.expressionEvaluator, messageProvider, messageStore);
        jacksonContentHandler.handle();
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, messageProvider, messageStore});
    }

    @Test
    public void handleNoConfig() throws IOException {
        HashMap hashMap = new HashMap();
        KitchenSinkAction kitchenSinkAction = new KitchenSinkAction(null);
        ActionConfiguration actionConfiguration = new ActionConfiguration(KitchenSinkAction.class, false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Collections.emptyList(), null, hashMap, null, null, null, null, null);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation((Object)kitchenSinkAction, null, "/action", null, actionConfiguration));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        String string = "{  \"active\":true,  \"addresses\":{    \"home\":{      \"city\":\"Broomfield\",      \"state\":\"Colorado\",      \"zipcode\":\"80023\"    },    \"work\":{      \"city\":\"Denver\",      \"state\":\"Colorado\",      \"zipcode\":\"80202\"    }  },  \"age\":37,  \"favoriteMonth\":5,  \"favoriteYear\":1976,  \"ids\":{    \"0\":1,    \"1\":2  },  \"lifeStory\":\"Hello world\",  \"securityQuestions\":[\"one\",\"two\",\"three\",\"four\"],  \"siblings\":[{    \"active\":false,    \"name\":\"Brett\"  },{    \"active\":false,    \"name\":\"Beth\"  }],  \"type\":\"COOL\"}";
        HTTPRequest hTTPRequest = new HTTPRequest();
        hTTPRequest.setInputStream((InputStream)new ByteArrayInputStream(string.getBytes()));
        hTTPRequest.setContentLength(Long.valueOf(string.getBytes().length));
        hTTPRequest.setContentType("application/json");
        MessageProvider messageProvider = (MessageProvider)EasyMock.createStrictMock(MessageProvider.class);
        EasyMock.replay((Object[])new Object[]{messageProvider});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.replay((Object[])new Object[]{messageStore});
        JacksonContentHandler jacksonContentHandler = new JacksonContentHandler(hTTPRequest, actionInvocationStore, new ObjectMapper(), this.expressionEvaluator, messageProvider, messageStore);
        jacksonContentHandler.handle();
        Assert.assertNull((Object)kitchenSinkAction.jsonRequest);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, messageProvider, messageStore});
    }
}

