/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.google.inject.Inject;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPContext;
import io.fusionauth.http.server.HTTPRequest;
import java.util.Collection;
import org.easymock.EasyMock;
import org.example.action.PostAction;
import org.example.action.SecureAction;
import org.example.action.SecureNoRolesAction;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.DefaultActionInvocationStore;
import org.primeframework.mvc.action.ExecuteMethodConfiguration;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.action.config.DefaultActionConfigurationBuilder;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.security.DefaultSecurityWorkflow;
import org.primeframework.mvc.security.DefaultUserLoginConstraintValidator;
import org.primeframework.mvc.security.MockUserLoginSecurityContext;
import org.primeframework.mvc.security.SecurityScheme;
import org.primeframework.mvc.security.UnauthenticatedException;
import org.primeframework.mvc.security.UnauthorizedException;
import org.primeframework.mvc.security.UserLoginConstraintsValidator;
import org.primeframework.mvc.security.UserLoginSecurityContext;
import org.primeframework.mvc.security.UserLoginSecurityScheme;
import org.primeframework.mvc.security.csrf.CSRFProvider;
import org.primeframework.mvc.security.guice.SecuritySchemeFactory;
import org.primeframework.mvc.workflow.WorkflowChain;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultSecurityWorkflowTest
extends PrimeBaseTest {
    @Inject
    public DefaultActionConfigurationBuilder actionConfigurationBuilder;
    @Inject
    public HTTPContext context;

    @Test
    public void performAuthenticationNotRequired() throws Exception {
        ActionConfiguration actionConfiguration = this.actionConfigurationBuilder.build(PostAction.class);
        ExecuteMethodConfiguration executeMethodConfiguration = new ExecuteMethodConfiguration(HTTPMethod.GET, null, null);
        ActionInvocation actionInvocation = new ActionInvocation((Object)new PostAction(), executeMethodConfiguration, null, null, actionConfiguration);
        DefaultActionInvocationStore defaultActionInvocationStore = new DefaultActionInvocationStore(this.request);
        defaultActionInvocationStore.setCurrent(actionInvocation);
        MockUserLoginSecurityContext.roles.clear();
        MockUserLoginSecurityContext mockUserLoginSecurityContext = new MockUserLoginSecurityContext();
        DefaultSecurityWorkflow defaultSecurityWorkflow = new DefaultSecurityWorkflow((ActionInvocationStore)defaultActionInvocationStore, (SecuritySchemeFactory)new TestSecuritySchemeFactory((MVCConfiguration)PrimeBaseTest.configuration, mockUserLoginSecurityContext, this.request, this.csrfProvider));
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        defaultSecurityWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{workflowChain});
    }

    @Test
    public void performAuthenticationRequiredNoRolesRequired() throws Exception {
        ActionConfiguration actionConfiguration = this.actionConfigurationBuilder.build(SecureNoRolesAction.class);
        ExecuteMethodConfiguration executeMethodConfiguration = new ExecuteMethodConfiguration(HTTPMethod.GET, null, null);
        ActionInvocation actionInvocation = new ActionInvocation((Object)new SecureNoRolesAction(), executeMethodConfiguration, null, null, actionConfiguration);
        DefaultActionInvocationStore defaultActionInvocationStore = new DefaultActionInvocationStore(this.request);
        defaultActionInvocationStore.setCurrent(actionInvocation);
        MockUserLoginSecurityContext.roles.clear();
        MockUserLoginSecurityContext.roles.add("bad");
        MockUserLoginSecurityContext mockUserLoginSecurityContext = new MockUserLoginSecurityContext();
        mockUserLoginSecurityContext.login("user");
        this.request.addCookies((Collection)this.response.getCookies());
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        this.request.setHost("example.com");
        this.request.addHeader("Origin", "http://example.com:10000");
        DefaultSecurityWorkflow defaultSecurityWorkflow = new DefaultSecurityWorkflow((ActionInvocationStore)defaultActionInvocationStore, (SecuritySchemeFactory)new TestSecuritySchemeFactory((MVCConfiguration)PrimeBaseTest.configuration, mockUserLoginSecurityContext, this.request, this.csrfProvider));
        defaultSecurityWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{workflowChain});
    }

    @Test
    public void performAuthenticationRequiredNotLoggedInGET() throws Exception {
        ActionConfiguration actionConfiguration = this.actionConfigurationBuilder.build(SecureAction.class);
        ExecuteMethodConfiguration executeMethodConfiguration = new ExecuteMethodConfiguration(HTTPMethod.GET, null, null);
        ActionInvocation actionInvocation = new ActionInvocation((Object)new SecureAction(), executeMethodConfiguration, null, null, actionConfiguration);
        DefaultActionInvocationStore defaultActionInvocationStore = new DefaultActionInvocationStore(this.request);
        defaultActionInvocationStore.setCurrent(actionInvocation);
        this.request.setMethod(HTTPMethod.GET);
        this.request.setPath("/secure");
        this.request.addURLParameter("test", "value");
        this.request.addURLParameter("test2", "value2");
        MockUserLoginSecurityContext.roles.clear();
        MockUserLoginSecurityContext mockUserLoginSecurityContext = new MockUserLoginSecurityContext();
        DefaultSecurityWorkflow defaultSecurityWorkflow = new DefaultSecurityWorkflow((ActionInvocationStore)defaultActionInvocationStore, (SecuritySchemeFactory)new TestSecuritySchemeFactory((MVCConfiguration)PrimeBaseTest.configuration, mockUserLoginSecurityContext, this.request, this.csrfProvider));
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        EasyMock.replay((Object[])new Object[]{workflowChain});
        try {
            defaultSecurityWorkflow.perform(workflowChain);
            Assert.fail((String)"Should have failed");
        }
        catch (UnauthenticatedException unauthenticatedException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{workflowChain});
    }

    @Test
    public void performAuthenticationRequiredNotLoggedInPOST() throws Exception {
        ActionConfiguration actionConfiguration = this.actionConfigurationBuilder.build(SecureAction.class);
        ExecuteMethodConfiguration executeMethodConfiguration = new ExecuteMethodConfiguration(HTTPMethod.POST, null, null);
        ActionInvocation actionInvocation = new ActionInvocation((Object)new SecureAction(), executeMethodConfiguration, null, null, actionConfiguration);
        DefaultActionInvocationStore defaultActionInvocationStore = new DefaultActionInvocationStore(this.request);
        defaultActionInvocationStore.setCurrent(actionInvocation);
        this.request.setMethod(HTTPMethod.POST);
        this.request.setPath("/secure");
        this.request.addURLParameter("test", "value");
        this.request.addURLParameter("test2", "value2");
        MockUserLoginSecurityContext.roles.clear();
        MockUserLoginSecurityContext mockUserLoginSecurityContext = new MockUserLoginSecurityContext();
        DefaultSecurityWorkflow defaultSecurityWorkflow = new DefaultSecurityWorkflow((ActionInvocationStore)defaultActionInvocationStore, (SecuritySchemeFactory)new TestSecuritySchemeFactory((MVCConfiguration)PrimeBaseTest.configuration, mockUserLoginSecurityContext, this.request, this.csrfProvider));
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        EasyMock.replay((Object[])new Object[]{workflowChain});
        try {
            defaultSecurityWorkflow.perform(workflowChain);
            Assert.fail((String)"Should have failed");
        }
        catch (UnauthenticatedException unauthenticatedException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{workflowChain});
    }

    @Test
    public void performAuthenticationRequiredSuccess() throws Exception {
        ActionConfiguration actionConfiguration = this.actionConfigurationBuilder.build(SecureAction.class);
        ExecuteMethodConfiguration executeMethodConfiguration = new ExecuteMethodConfiguration(HTTPMethod.GET, null, null);
        ActionInvocation actionInvocation = new ActionInvocation((Object)new SecureAction(), executeMethodConfiguration, null, null, actionConfiguration);
        DefaultActionInvocationStore defaultActionInvocationStore = new DefaultActionInvocationStore(this.request);
        defaultActionInvocationStore.setCurrent(actionInvocation);
        MockUserLoginSecurityContext.roles.clear();
        MockUserLoginSecurityContext.roles.add("admin");
        MockUserLoginSecurityContext mockUserLoginSecurityContext = new MockUserLoginSecurityContext();
        mockUserLoginSecurityContext.login("user");
        this.request.addCookies((Collection)this.response.getCookies());
        DefaultSecurityWorkflow defaultSecurityWorkflow = new DefaultSecurityWorkflow((ActionInvocationStore)defaultActionInvocationStore, (SecuritySchemeFactory)new TestSecuritySchemeFactory((MVCConfiguration)PrimeBaseTest.configuration, mockUserLoginSecurityContext, this.request, this.csrfProvider));
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        this.request.setHost("example.com");
        this.request.addHeader("Origin", "http://example.com:10000");
        defaultSecurityWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{workflowChain});
    }

    @Test
    public void performAuthenticationRequiredWrongRoles() throws Exception {
        ActionConfiguration actionConfiguration = this.actionConfigurationBuilder.build(SecureAction.class);
        ExecuteMethodConfiguration executeMethodConfiguration = new ExecuteMethodConfiguration(HTTPMethod.GET, null, null);
        ActionInvocation actionInvocation = new ActionInvocation((Object)new SecureAction(), executeMethodConfiguration, null, null, actionConfiguration);
        DefaultActionInvocationStore defaultActionInvocationStore = new DefaultActionInvocationStore(this.request);
        defaultActionInvocationStore.setCurrent(actionInvocation);
        MockUserLoginSecurityContext.roles.clear();
        MockUserLoginSecurityContext.roles.add("bad");
        MockUserLoginSecurityContext mockUserLoginSecurityContext = new MockUserLoginSecurityContext();
        mockUserLoginSecurityContext.login("user");
        this.request.addCookies((Collection)this.response.getCookies());
        DefaultSecurityWorkflow defaultSecurityWorkflow = new DefaultSecurityWorkflow((ActionInvocationStore)defaultActionInvocationStore, (SecuritySchemeFactory)new TestSecuritySchemeFactory((MVCConfiguration)PrimeBaseTest.configuration, mockUserLoginSecurityContext, this.request, this.csrfProvider));
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        EasyMock.replay((Object[])new Object[]{workflowChain});
        try {
            defaultSecurityWorkflow.perform(workflowChain);
            Assert.fail((String)"Should have thrown");
        }
        catch (UnauthorizedException unauthorizedException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{workflowChain});
    }

    @Test
    public void performNotConfigured() throws Exception {
        ActionConfiguration actionConfiguration = this.actionConfigurationBuilder.build(PostAction.class);
        ExecuteMethodConfiguration executeMethodConfiguration = new ExecuteMethodConfiguration(HTTPMethod.GET, null, null);
        ActionInvocation actionInvocation = new ActionInvocation((Object)new PostAction(), executeMethodConfiguration, null, null, actionConfiguration);
        DefaultActionInvocationStore defaultActionInvocationStore = new DefaultActionInvocationStore(this.request);
        defaultActionInvocationStore.setCurrent(actionInvocation);
        DefaultSecurityWorkflow defaultSecurityWorkflow = new DefaultSecurityWorkflow((ActionInvocationStore)defaultActionInvocationStore, (SecuritySchemeFactory)new TestSecuritySchemeFactory((MVCConfiguration)PrimeBaseTest.configuration, null, this.request, this.csrfProvider));
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        defaultSecurityWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{workflowChain});
    }

    public static class TestSecuritySchemeFactory
    extends SecuritySchemeFactory {
        private final MVCConfiguration configuration;
        private final CSRFProvider csrfProvider;
        private final HTTPRequest request;
        private final MockUserLoginSecurityContext securityContext;

        public TestSecuritySchemeFactory(MVCConfiguration mVCConfiguration, MockUserLoginSecurityContext mockUserLoginSecurityContext, HTTPRequest hTTPRequest, CSRFProvider cSRFProvider) {
            super(PrimeBaseTest.injector);
            this.configuration = mVCConfiguration;
            this.securityContext = mockUserLoginSecurityContext;
            this.csrfProvider = cSRFProvider;
            this.request = hTTPRequest;
        }

        public SecurityScheme build(String string) {
            DefaultUserLoginConstraintValidator defaultUserLoginConstraintValidator = new DefaultUserLoginConstraintValidator();
            defaultUserLoginConstraintValidator.setUserLoginSecurityContext((UserLoginSecurityContext)this.securityContext);
            UserLoginSecurityScheme userLoginSecurityScheme = new UserLoginSecurityScheme(this.configuration, (UserLoginConstraintsValidator)defaultUserLoginConstraintValidator, this.csrfProvider, this.request, this.request.getMethod());
            userLoginSecurityScheme.setUserLoginSecurityContext((UserLoginSecurityContext)this.securityContext);
            return userLoginSecurityScheme;
        }
    }
}

