/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.workflow;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.primeframework.mvc.action.ActionInvocationWorkflow;
import org.primeframework.mvc.action.ActionMappingWorkflow;
import org.primeframework.mvc.action.result.ResultInvocationWorkflow;
import org.primeframework.mvc.content.ContentWorkflow;
import org.primeframework.mvc.cors.CORSRequestWorkflow;
import org.primeframework.mvc.message.MessageWorkflow;
import org.primeframework.mvc.parameter.ParameterWorkflow;
import org.primeframework.mvc.parameter.PostParameterWorkflow;
import org.primeframework.mvc.parameter.URIParameterWorkflow;
import org.primeframework.mvc.scope.ScopeRetrievalWorkflow;
import org.primeframework.mvc.scope.ScopeStorageWorkflow;
import org.primeframework.mvc.security.SavedRequestWorkflow;
import org.primeframework.mvc.security.SecurityWorkflow;
import org.primeframework.mvc.validation.ValidationWorkflow;
import org.primeframework.mvc.workflow.ErrorWorkflow;
import org.primeframework.mvc.workflow.ExceptionHandler;
import org.primeframework.mvc.workflow.MVCWorkflow;
import org.primeframework.mvc.workflow.MissingWorkflow;
import org.primeframework.mvc.workflow.StaticResourceWorkflow;
import org.primeframework.mvc.workflow.SubWorkflowChain;
import org.primeframework.mvc.workflow.Workflow;
import org.primeframework.mvc.workflow.WorkflowChain;

public class DefaultMVCWorkflow
implements MVCWorkflow {
    private final ErrorWorkflow errorWorkflow;
    private final ExceptionHandler exceptionHandler;
    private final HTTPResponse response;
    private final List<Workflow> workflows;

    @Inject
    public DefaultMVCWorkflow(CORSRequestWorkflow corsRequestWorkflow, SavedRequestWorkflow savedRequestWorkflow, ActionMappingWorkflow actionMappingWorkflow, ScopeRetrievalWorkflow scopeRetrievalWorkflow, URIParameterWorkflow uriParameterWorkflow, ParameterWorkflow parameterWorkflow, ContentWorkflow contentWorkflow, PostParameterWorkflow postParameterWorkflow, SecurityWorkflow securityWorkflow, ValidationWorkflow validationWorkflow, MessageWorkflow messageWorkflow, ActionInvocationWorkflow actionInvocationWorkflow, ScopeStorageWorkflow scopeStorageWorkflow, ResultInvocationWorkflow resultInvocationWorkflow, StaticResourceWorkflow staticResourceWorkflow, MissingWorkflow missingWorkflow, ErrorWorkflow errorWorkflow, ExceptionHandler exceptionHandler, HTTPResponse response) {
        this.exceptionHandler = exceptionHandler;
        this.errorWorkflow = errorWorkflow;
        this.response = response;
        this.workflows = Arrays.asList(corsRequestWorkflow, savedRequestWorkflow, actionMappingWorkflow, scopeRetrievalWorkflow, uriParameterWorkflow, parameterWorkflow, contentWorkflow, postParameterWorkflow, securityWorkflow, validationWorkflow, messageWorkflow, actionInvocationWorkflow, scopeStorageWorkflow, resultInvocationWorkflow, staticResourceWorkflow, missingWorkflow);
    }

    @Override
    public void perform(WorkflowChain workflowChain) throws IOException {
        try {
            SubWorkflowChain chain = new SubWorkflowChain(this.workflows, workflowChain);
            chain.continueWorkflow();
        }
        catch (Error | RuntimeException e) {
            if (this.response.isCommitted()) {
                throw e;
            }
            List cookies = List.copyOf(this.response.getCookies());
            Map headers = Map.copyOf(this.response.getHeadersMap());
            this.response.reset();
            headers.keySet().forEach(k -> ((List)headers.get(k)).forEach(v -> this.response.addHeader(k, v)));
            cookies.forEach(arg_0 -> ((HTTPResponse)this.response).addCookie(arg_0));
            this.exceptionHandler.handle(e);
            SubWorkflowChain errorChain = new SubWorkflowChain(Collections.singletonList(this.errorWorkflow), workflowChain);
            errorChain.continueWorkflow();
        }
    }
}

