/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.primeframework.mvc.PrimeException;

public class Classpath {
    private final List<String> names = new ArrayList<String>();

    public Classpath(List<String> names) {
        this.names.addAll(names);
    }

    public static ClasspathBuilder build(ClassLoader loader) {
        return new ClasspathBuilder(loader);
    }

    public static ClasspathBuilder build() {
        return new ClasspathBuilder(Thread.currentThread().getContextClassLoader());
    }

    public static Classpath getCurrentClassPath() throws IOException {
        ClasspathBuilder builder = new ClasspathBuilder(Thread.currentThread().getContextClassLoader());
        return builder.build();
    }

    public void addAllFiles(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            this.addFile(file);
        }
    }

    public void addEntry(String entry) {
        this.names.add(entry);
    }

    public void addFile(File file) {
        this.names.add(file.getAbsolutePath());
    }

    public List<String> getNames() {
        return Collections.unmodifiableList(this.names);
    }

    public void removeEntry(String entry) {
        this.names.remove(entry);
    }

    public void removeFile(File file) {
        this.names.remove(file.getAbsolutePath());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.names.size(); ++i) {
            String entry = this.names.get(i);
            if (i != 0) {
                buf.append(File.pathSeparator);
            }
            buf.append(entry);
        }
        return buf.toString();
    }

    public URLClassLoader toURLClassLoader(ClassLoader parent) throws IllegalStateException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < this.names.size(); ++i) {
            URL url;
            String s = this.names.get(i);
            try {
                url = new URL(s);
            }
            catch (MalformedURLException e) {
                File f = new File(s);
                if (f.exists()) {
                    try {
                        url = f.toURI().toURL();
                    }
                    catch (MalformedURLException e1) {
                        throw new PrimeException("Cannot create URLClassLoader because classpath entry [" + s + "] could not be converted to a URL from a File.");
                    }
                }
                throw new PrimeException("Cannot create URLClassLoader because classpath entry [" + s + "] is not a URL or a File.");
            }
            urls.add(url);
        }
        URLClassLoader cl = parent == null ? new URLClassLoader(urls.toArray(new URL[urls.size()])) : new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
        return cl;
    }

    public static class ClasspathBuilder {
        private final ClassLoader classLoader;
        private final Set<Pattern> excludePatterns = new HashSet<Pattern>();
        private final Set<String> excludes = new HashSet<String>();

        public ClasspathBuilder(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public void addExclude(String exclude) {
            this.excludes.add(exclude);
        }

        public void addExcludePattern(Pattern pattern) {
            this.excludePatterns.add(pattern);
        }

        public Classpath build() throws IOException {
            String[] parts;
            String path;
            HashSet<String> list = new HashSet<String>();
            ArrayList<URL> urls = Collections.list(this.classLoader.getResources("META-INF"));
            for (URL url : urls) {
                path = this.clean(url);
                if (path == null || this.exclude(path)) continue;
                list.add(path);
            }
            urls = Collections.list(this.classLoader.getResources(""));
            for (URL url : urls) {
                path = this.clean(url);
                if (path == null || this.exclude(path)) continue;
                list.add(path);
            }
            for (String part : parts = System.getProperty("java.class.path").split(File.pathSeparator)) {
                if (part == null || this.exclude(part)) continue;
                list.add(part);
            }
            return new Classpath(new ArrayList<String>(list));
        }

        private String clean(URL url) throws IOException {
            try {
                String externalForm = url.toURI().getSchemeSpecificPart();
                if (externalForm.endsWith("META-INF")) {
                    externalForm = externalForm.substring(0, externalForm.length() - 8);
                } else if (externalForm.endsWith("META-INF/")) {
                    externalForm = externalForm.substring(0, externalForm.length() - 9);
                }
                if (externalForm.endsWith("!/")) {
                    externalForm = externalForm.substring(0, externalForm.length() - 2);
                }
                if (externalForm.startsWith("file:")) {
                    externalForm = externalForm.substring(5);
                }
                if (externalForm.startsWith("jar:file:")) {
                    externalForm = externalForm.substring(9);
                }
                return new File(externalForm).getPath();
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }

        private boolean exclude(String externalForm) {
            for (String exclude : this.excludes) {
                if (!externalForm.equals(exclude)) continue;
                return true;
            }
            for (Pattern pattern : this.excludePatterns) {
                if (!pattern.matcher(externalForm).matches()) continue;
                return true;
            }
            return false;
        }
    }
}

