/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.json;

import java.util.ArrayDeque;
import java.util.Deque;

public class JSONBuilder {
    public static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final StringBuilder build;
    private final Deque<Boolean> firstField = new ArrayDeque<Boolean>();
    private final boolean pretty;

    public JSONBuilder(StringBuilder build, boolean pretty) {
        this.build = build;
        this.pretty = pretty;
        this.firstField.push(true);
    }

    public static String escape(String str) {
        StringBuilder build = new StringBuilder();
        JSONBuilder.escape(str, build);
        return build.toString();
    }

    public static void escape(String str, StringBuilder build) {
        char[] ca;
        block9: for (char c : ca = str.toCharArray()) {
            switch (c) {
                case '\"': 
                case '\\': {
                    build.append('\\');
                    build.append(c);
                    continue block9;
                }
                case '\r': {
                    build.append("\\r");
                    continue block9;
                }
                case '\n': {
                    build.append("\\n");
                    continue block9;
                }
                case '\t': {
                    build.append("\\t");
                    continue block9;
                }
                case '\b': {
                    build.append("\\b");
                    continue block9;
                }
                case '\f': {
                    build.append("\\f");
                    continue block9;
                }
                case '/': {
                    build.append("\\/");
                    continue block9;
                }
                default: {
                    if (c <= '\u001f') {
                        JSONBuilder.unicodeEscape(c, build);
                        continue block9;
                    }
                    build.append(c);
                }
            }
        }
    }

    public static void unicodeEscape(int ch, StringBuilder build) {
        build.append('\\');
        build.append('u');
        build.append(HEX_CHARS[ch >>> 12]);
        build.append(HEX_CHARS[ch >>> 8 & 0xF]);
        build.append(HEX_CHARS[ch >>> 4 & 0xF]);
        build.append(HEX_CHARS[ch & 0xF]);
    }

    public JSONBuilder addBooleanField(String name, Boolean value) {
        if (value == null) {
            return this;
        }
        this.addComma();
        this.indent();
        this.appendString(name);
        this.build.append(":").append(value);
        return this;
    }

    public JSONBuilder addEnumOrdinalField(String name, Enum<?> value) {
        if (value == null) {
            return this;
        }
        this.addIntField(name, value.ordinal());
        return this;
    }

    public JSONBuilder addIntField(String name, Integer value) {
        if (value == null) {
            return this;
        }
        this.addComma();
        this.indent();
        this.appendString(name);
        this.build.append(":").append(value);
        return this;
    }

    public JSONBuilder addStringField(String name, String value) {
        if (value == null) {
            return this;
        }
        this.addComma();
        this.indent();
        this.appendString(name);
        this.build.append(":");
        this.appendString(value);
        return this;
    }

    public JSONBuilder endArray() {
        this.firstField.pop();
        if (this.pretty) {
            this.build.append("\n");
            this.indent();
        }
        this.build.append("]");
        return this;
    }

    public JSONBuilder endObject() {
        this.firstField.pop();
        if (this.pretty) {
            this.build.append("\n");
            this.indent();
        }
        this.build.append("}");
        return this;
    }

    public JSONBuilder startArray(String name) {
        this.addComma();
        this.indent();
        this.appendString(name);
        this.build.append(":[");
        if (this.pretty) {
            this.build.append("\n");
        }
        this.firstField.push(true);
        return this;
    }

    public JSONBuilder startObject() {
        this.addComma();
        this.indent();
        this.build.append("{");
        if (this.pretty) {
            this.build.append("\n");
        }
        this.firstField.push(true);
        return this;
    }

    public JSONBuilder startObject(String name) {
        this.addComma();
        this.indent();
        this.appendString(name);
        this.build.append(":{");
        if (this.pretty) {
            this.build.append("\n");
        }
        this.firstField.push(true);
        return this;
    }

    public String toString() {
        return this.build.toString();
    }

    private void addComma() {
        if (!this.firstField.peek().booleanValue()) {
            this.build.append(",");
            if (this.pretty) {
                this.build.append("\n");
            }
        } else {
            this.firstField.pop();
            this.firstField.push(false);
        }
    }

    private void appendString(String str) {
        this.build.append("\"");
        JSONBuilder.escape(str, this.build);
        this.build.append("\"");
    }

    private void indent() {
        if (!this.pretty) {
            return;
        }
        for (int i = 1; i < this.firstField.size(); ++i) {
            this.build.append("  ");
        }
    }
}

