/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.http;

import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Flow;

public class FormBodyPublisher
implements HttpRequest.BodyPublisher {
    private final byte[] body;
    private final HttpRequest.BodyPublisher publisher;

    public FormBodyPublisher(Map<String, List<String>> request, boolean excludeNullValues) {
        this.body = this.createBody(request, excludeNullValues);
        this.publisher = HttpRequest.BodyPublishers.ofByteArray(this.body);
    }

    public FormBodyPublisher(Map<String, List<String>> request) {
        this(request, false);
    }

    private static void append(StringBuilder build, String key, String value) {
        if (!build.isEmpty()) {
            build.append("&");
        }
        build.append(FormBodyPublisher.encode(key)).append("=");
        if (value != null) {
            build.append(FormBodyPublisher.encode(value));
        }
    }

    private static String encode(String s) {
        return URLEncoder.encode(s, StandardCharsets.UTF_8);
    }

    private static byte[] serializeRequest(Map<String, List<String>> request, boolean excludeNullValues) {
        StringBuilder build = new StringBuilder();
        request.forEach((key, values) -> {
            if (values == null) {
                if (!excludeNullValues) {
                    FormBodyPublisher.append(build, key, null);
                }
                return;
            }
            values.stream().filter(v -> v != null || !excludeNullValues).forEach(v -> FormBodyPublisher.append(build, key, v));
        });
        return build.toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public long contentLength() {
        return this.publisher.contentLength();
    }

    public byte[] getBody() {
        return this.body;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        this.publisher.subscribe(subscriber);
    }

    private byte[] createBody(Map<String, List<String>> request, boolean excludeNullValues) {
        if (request != null) {
            return FormBodyPublisher.serializeRequest(request, excludeNullValues);
        }
        return null;
    }
}

