/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.freemarker;

import com.google.inject.Inject;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.primeframework.mvc.container.ContainerResolver;
import org.primeframework.mvc.freemarker.URLTemplateSource;

public class OverridingTemplateLoader
implements TemplateLoader {
    private final ContainerResolver containerResolver;

    @Inject
    public OverridingTemplateLoader(ContainerResolver containerResolver) {
        this.containerResolver = containerResolver;
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        ((URLTemplateSource)templateSource).close();
    }

    public Object findTemplateSource(String name) throws IOException {
        try {
            File file;
            String realPath = this.containerResolver.getRealPath(name);
            if (realPath != null && (file = new File(realPath)).isFile() && file.canRead()) {
                return new URLTemplateSource(file.toURI().toURL());
            }
        }
        catch (SecurityException realPath) {
            // empty catch block
        }
        URL url = this.containerResolver.getResource(name);
        if (url == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            url = cl.getResource(name);
        }
        return url == null ? null : new URLTemplateSource(url);
    }

    public long getLastModified(Object templateSource) {
        return ((URLTemplateSource)templateSource).lastModified();
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        return new InputStreamReader(((URLTemplateSource)templateSource).getInputStream(), encoding);
    }
}

