/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.control;

import com.google.inject.Inject;
import freemarker.template.Configuration;
import io.fusionauth.http.server.HTTPRequest;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.control.Body;
import org.primeframework.mvc.control.Control;
import org.primeframework.mvc.control.annotation.ControlAttribute;
import org.primeframework.mvc.control.annotation.ControlAttributes;
import org.primeframework.mvc.control.form.JoinMethod;
import org.primeframework.mvc.control.message.Message;
import org.primeframework.mvc.freemarker.FreeMarkerService;
import org.primeframework.mvc.locale.LocaleProvider;
import org.primeframework.mvc.message.l10n.MessageProvider;
import org.primeframework.mvc.security.csrf.CSRFProvider;
import org.primeframework.mvc.util.ErrorList;

public abstract class AbstractControl
implements Control {
    protected final Map<String, Object> attributes = new TreeMap<String, Object>();
    protected final Map<String, String> dynamicAttributes = new TreeMap<String, String>();
    protected final Map<String, Object> parameters = new TreeMap<String, Object>();
    protected ActionInvocationStore actionInvocationStore;
    protected MVCConfiguration configuration;
    protected CSRFProvider csrfProvider;
    protected Configuration freeMarkerConfig;
    protected FreeMarkerService freeMarkerService;
    protected LocaleProvider localeProvider;
    protected MessageProvider messageProvider;
    protected HTTPRequest request;
    protected Object root;

    @Override
    public void renderBody(Writer writer, Body body) {
        body.render(writer);
    }

    @Override
    public void renderEnd(Writer writer) {
        if (this.endTemplateName() != null) {
            String templateName = this.configuration.controlTemplateDirectory() + "/" + this.endTemplateName();
            this.freeMarkerService.render(writer, templateName, this.root);
        }
    }

    @Override
    public void renderStart(Writer writer, Map<String, Object> attributes, Map<String, String> dynamicAttributes) {
        this.attributes.clear();
        this.dynamicAttributes.clear();
        this.parameters.clear();
        this.attributes.putAll(attributes);
        this.dynamicAttributes.putAll(dynamicAttributes);
        this.verifyAttributes();
        this.addAdditionalAttributes();
        this.parameters.putAll(this.makeParameters());
        this.root = this.makeRoot();
        if (this.startTemplateName() != null) {
            String templateName = this.configuration.controlTemplateDirectory() + "/" + this.startTemplateName();
            this.freeMarkerService.render(writer, templateName, this.root);
        }
    }

    @Inject
    public void setServices(LocaleProvider localeProvider, HTTPRequest request, ActionInvocationStore actionInvocationStore, FreeMarkerService freeMarkerService, MVCConfiguration configuration, Configuration freeMarkerConfig, MessageProvider messageProvider, CSRFProvider csrfProvider) {
        this.csrfProvider = csrfProvider;
        this.localeProvider = localeProvider;
        this.request = request;
        this.freeMarkerService = freeMarkerService;
        this.actionInvocationStore = actionInvocationStore;
        this.configuration = configuration;
        this.freeMarkerConfig = freeMarkerConfig;
        this.messageProvider = messageProvider;
    }

    protected void addAdditionalAttributes() {
    }

    protected String controlName() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    protected Object currentAction() {
        return this.currentInvocation().action;
    }

    protected ActionInvocation currentInvocation() {
        return this.actionInvocationStore.getCurrent();
    }

    protected abstract String endTemplateName();

    protected Map<String, Object> makeParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.configuration.csrfEnabled()) {
            parameters.put("csrfToken", this.csrfProvider.getToken(this.request));
            parameters.put("csrfTokenName", this.csrfProvider.getParameterName());
        }
        parameters.put("attributes", this.attributes);
        parameters.put("dynamicAttributes", this.dynamicAttributes);
        parameters.put("join", new JoinMethod(this.freeMarkerConfig.getObjectWrapper()));
        parameters.put("message", new Message(this.messageProvider));
        return parameters;
    }

    protected Object makeRoot() {
        return this.parameters;
    }

    protected abstract String startTemplateName();

    private String toTypeListString(Class<?>[] attributeTypes) {
        StringBuilder build = new StringBuilder();
        for (int i = 0; i < attributeTypes.length; ++i) {
            Class<?> attributeType = attributeTypes[i];
            build.append(attributeType.toString());
            if (i == attributeTypes.length - 2) {
                build.append(", or ");
                continue;
            }
            if (i <= 0) continue;
            build.append(", ");
        }
        return build.toString();
    }

    private void verifyAttributes(Map<String, Object> attributes, ControlAttribute[] controlAttributes, boolean required, ErrorList errors) {
        for (ControlAttribute controlAttribute : controlAttributes) {
            Class<?> attributeType;
            Object value = attributes.get(controlAttribute.name());
            if (value == null && required) {
                Object name = attributes.get("name");
                String nameAttribute = name != null ? " with name [" + String.valueOf(name) + "]" : "";
                errors.addError("The [" + this.controlName() + "] control" + nameAttribute + " is missing the required attribute [" + controlAttribute.name() + "]");
                continue;
            }
            if (value == null) continue;
            Class<?>[] attributeTypes = controlAttribute.types();
            boolean found = false;
            Class<?>[] classArray = attributeTypes;
            int n = classArray.length;
            for (int i = 0; i < n && !(found = (attributeType = classArray[i]).isInstance(value)); ++i) {
            }
            if (found) continue;
            Object name = attributes.get("name");
            String nameAttribute = name != null ? " with name [" + String.valueOf(name) + "]" : "";
            errors.addError("The [" + this.controlName() + "] control" + nameAttribute + " has an invalid attribute [" + controlAttribute.name() + "] of type [" + String.valueOf(value.getClass()) + "]. It must be an instance of [" + this.toTypeListString(attributeTypes) + "]");
        }
    }

    private void verifyAttributes() {
        ErrorList errors = new ErrorList();
        Class<?> type = this.getClass();
        ControlAttributes ca = type.getAnnotation(ControlAttributes.class);
        if (ca != null) {
            ControlAttribute[] requiredAttributes = ca.required();
            this.verifyAttributes(this.attributes, requiredAttributes, true, errors);
            ControlAttribute[] optionalAttributes = ca.optional();
            this.verifyAttributes(this.attributes, optionalAttributes, false, errors);
        }
        if (!errors.isEmpty()) {
            throw new PrimeException(errors.toString());
        }
    }
}

