/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.content.binary;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.content.ContentHandler;
import org.primeframework.mvc.content.binary.BinaryActionConfiguration;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;

public class BinaryContentHandler
implements ContentHandler {
    public static final String RequestAttribute = "prime-mvc-body-file";
    private final ExpressionEvaluator expressionEvaluator;
    private final HTTPRequest request;
    private final ActionInvocationStore store;

    @Inject
    public BinaryContentHandler(ExpressionEvaluator expressionEvaluator, HTTPRequest request, ActionInvocationStore store) {
        this.expressionEvaluator = expressionEvaluator;
        this.request = request;
        this.store = store;
    }

    @Override
    public void cleanup() {
        Path tmpFile = (Path)this.request.getAttribute(RequestAttribute);
        if (tmpFile != null) {
            try {
                Files.deleteIfExists(tmpFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void handle() throws IOException {
        if (this.request.isMultipart()) {
            return;
        }
        ActionInvocation actionInvocation = this.store.getCurrent();
        Object action = actionInvocation.action;
        if (action == null) {
            return;
        }
        ActionConfiguration config = actionInvocation.configuration;
        if (!config.additionalConfiguration.containsKey(BinaryActionConfiguration.class)) {
            return;
        }
        Long contentLength = this.request.getContentLength();
        if (contentLength == null || contentLength == 0L) {
            return;
        }
        BinaryActionConfiguration binaryConfig = (BinaryActionConfiguration)config.additionalConfiguration.get(BinaryActionConfiguration.class);
        if (binaryConfig.requestMember == null) {
            return;
        }
        try {
            Path tmpFile = Files.createTempFile("prime-mvc", "binary", new FileAttribute[0]);
            try (OutputStream output = Files.newOutputStream(tmpFile, new OpenOption[0]);){
                this.request.getInputStream().transferTo(output);
            }
            this.request.setAttribute(RequestAttribute, (Object)tmpFile);
            this.expressionEvaluator.setValue(binaryConfig.requestMember, action, tmpFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

