/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPResponse;
import java.lang.annotation.Annotation;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.result.Result;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;

public abstract class AbstractResult<U extends Annotation>
implements Result<U> {
    protected final ExpressionEvaluator expressionEvaluator;

    protected AbstractResult(ExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }

    protected void addCacheControlHeader(U result, HTTPResponse response) {
        if (this.getDisableCacheControl(result)) {
            return;
        }
        response.setHeader("Cache-Control", this.getCacheControl(result));
    }

    protected String expand(String str, Object action, boolean encode) {
        if (action != null) {
            return this.expressionEvaluator.expand(str, action, encode);
        }
        return str;
    }

    protected abstract String getCacheControl(U var1);

    protected abstract boolean getDisableCacheControl(U var1);

    protected boolean isHeadRequest(ActionInvocation actionInvocation) {
        return actionInvocation.method != null && HTTPMethod.HEAD.is(actionInvocation.method.httpMethod);
    }

    protected void setStatus(int status, String statusStr, Object action, HTTPResponse response) {
        int code = status;
        if (!statusStr.isEmpty()) {
            code = Integer.parseInt(this.expand(statusStr, action, false));
        }
        response.setStatus(code);
    }
}

