/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.lang.annotation.Annotation;
import java.util.List;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.result.AbstractResult;
import org.primeframework.mvc.message.Message;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.scope.MessageScope;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;

public abstract class AbstractRedirectResult<T extends Annotation>
extends AbstractResult<T> {
    protected final ActionInvocationStore actionInvocationStore;
    protected final MessageStore messageStore;
    protected final HTTPRequest request;
    protected final HTTPResponse response;

    protected AbstractRedirectResult(ExpressionEvaluator expressionEvaluator, ActionInvocationStore actionInvocationStore, MessageStore messageStore, HTTPRequest request, HTTPResponse response) {
        super(expressionEvaluator);
        this.actionInvocationStore = actionInvocationStore;
        this.messageStore = messageStore;
        this.request = request;
        this.response = response;
    }

    protected void moveMessagesToFlash() {
        List<Message> messages = this.messageStore.get(MessageScope.REQUEST);
        this.messageStore.clear(MessageScope.REQUEST);
        this.messageStore.addAll(MessageScope.FLASH, messages);
    }

    protected void sendRedirect(String uri, String defaultURI, boolean encodeVariables, boolean perm) {
        String context;
        if (uri == null) {
            uri = this.expand(defaultURI, this.actionInvocationStore.getCurrent().action, encodeVariables);
        }
        if ((context = this.request.getContextPath()).length() > 0 && ((String)uri).startsWith("/")) {
            uri = context + (String)uri;
        }
        this.response.sendRedirect((String)uri);
        this.response.setStatus(perm ? 301 : 302);
    }
}

