/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action;

import com.google.inject.Inject;
import com.google.inject.Injector;
import io.fusionauth.http.HTTPMethod;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionMapper;
import org.primeframework.mvc.action.config.ActionConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultActionMapper
implements ActionMapper {
    private static final Logger logger = LoggerFactory.getLogger(DefaultActionMapper.class);
    private final ActionConfigurationProvider actionConfigurationProvider;
    private final Injector injector;

    @Inject
    public DefaultActionMapper(ActionConfigurationProvider actionConfigurationProvider, Injector injector) {
        this.actionConfigurationProvider = actionConfigurationProvider;
        this.injector = injector;
    }

    @Override
    public ActionInvocation map(HTTPMethod httpMethod, String uri) {
        ActionInvocation invocation = this.actionConfigurationProvider.lookup(uri);
        if (invocation.configuration == null && !uri.endsWith("/")) {
            ActionInvocation indexInvocation = this.actionConfigurationProvider.lookup(uri + "/index");
            if (indexInvocation.configuration != null) {
                indexInvocation.actionURI = indexInvocation.actionURI.substring(0, indexInvocation.actionURI.length() - 5);
                indexInvocation.redirect = true;
                return indexInvocation;
            }
        } else if (invocation.configuration != null) {
            long start = System.currentTimeMillis();
            invocation.action = this.injector.getInstance(invocation.configuration.actionClass);
            if (logger.isDebugEnabled()) {
                logger.debug("Injection took [{}] for [{}]", (Object)(System.currentTimeMillis() - start), (Object)invocation.actionURI);
            }
            invocation.method = invocation.configuration.executeMethods.get(httpMethod);
        }
        return invocation;
    }
}

