/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.freemarker;

import freemarker.cache.TemplateLoader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import org.easymock.EasyMock;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.container.ContainerResolver;
import org.primeframework.mvc.freemarker.Bean;
import org.primeframework.mvc.freemarker.DefaultFreeMarkerService;
import org.primeframework.mvc.freemarker.OverridingTemplateLoader;
import org.primeframework.mvc.freemarker.guice.FreeMarkerConfigurationProvider;
import org.primeframework.mvc.locale.LocaleProvider;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultFreeMarkerServiceTest {
    @Test
    public void locale() {
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.templateCheckSeconds()).andReturn((Object)2);
        EasyMock.expect((Object)mVCConfiguration.autoHTMLEscapingEnabled()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        ContainerResolver containerResolver = (ContainerResolver)EasyMock.createStrictMock(ContainerResolver.class);
        EasyMock.expect((Object)containerResolver.getRealPath("src/test/java/org/primeframework/mvc/freemarker/test-locale_fr.ftl")).andReturn((Object)"src/test/java/org/primeframework/mvc/freemarker/test-locale.ftl");
        EasyMock.replay((Object[])new Object[]{containerResolver});
        LocaleProvider localeProvider = (LocaleProvider)EasyMock.createStrictMock(LocaleProvider.class);
        EasyMock.expect((Object)((Locale)localeProvider.get())).andReturn((Object)Locale.FRENCH);
        EasyMock.replay((Object[])new Object[]{localeProvider});
        DefaultFreeMarkerService defaultFreeMarkerService = new DefaultFreeMarkerService(new FreeMarkerConfigurationProvider(mVCConfiguration, (TemplateLoader)new OverridingTemplateLoader(containerResolver)).get(), localeProvider);
        HashMap hashMap = new HashMap();
        StringWriter stringWriter = new StringWriter();
        defaultFreeMarkerService.render((Writer)stringWriter, "src/test/java/org/primeframework/mvc/freemarker/test-locale.ftl", hashMap);
        Assert.assertEquals((String)stringWriter.toString(), (String)"3,14");
    }

    @Test
    public void objectWrapper() {
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.templateCheckSeconds()).andReturn((Object)2);
        EasyMock.expect((Object)mVCConfiguration.autoHTMLEscapingEnabled()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        ContainerResolver containerResolver = (ContainerResolver)EasyMock.createStrictMock(ContainerResolver.class);
        EasyMock.expect((Object)containerResolver.getRealPath("src/test/java/org/primeframework/mvc/freemarker/test-with-bean_en_US.ftl")).andReturn((Object)"src/test/java/org/primeframework/mvc/freemarker/test-with-bean.ftl");
        EasyMock.replay((Object[])new Object[]{containerResolver});
        LocaleProvider localeProvider = (LocaleProvider)EasyMock.createStrictMock(LocaleProvider.class);
        EasyMock.expect((Object)((Locale)localeProvider.get())).andReturn((Object)Locale.US);
        EasyMock.replay((Object[])new Object[]{localeProvider});
        DefaultFreeMarkerService defaultFreeMarkerService = new DefaultFreeMarkerService(new FreeMarkerConfigurationProvider(mVCConfiguration, (TemplateLoader)new OverridingTemplateLoader(containerResolver)).get(), localeProvider);
        Bean bean = new Bean();
        bean.coolMap.put(1, "test");
        bean.setAge(42);
        HashMap<String, Bean> hashMap = new HashMap<String, Bean>();
        hashMap.put("bean", bean);
        StringWriter stringWriter = new StringWriter();
        defaultFreeMarkerService.render((Writer)stringWriter, "src/test/java/org/primeframework/mvc/freemarker/test-with-bean.ftl", hashMap);
        Assert.assertEquals((String)stringWriter.toString(), (String)"Bean 1 test test 42");
    }

    @Test
    public void use() {
        MVCConfiguration mVCConfiguration = (MVCConfiguration)EasyMock.createStrictMock(MVCConfiguration.class);
        EasyMock.expect((Object)mVCConfiguration.templateCheckSeconds()).andReturn((Object)2);
        EasyMock.expect((Object)mVCConfiguration.autoHTMLEscapingEnabled()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{mVCConfiguration});
        ContainerResolver containerResolver = (ContainerResolver)EasyMock.createStrictMock(ContainerResolver.class);
        EasyMock.expect((Object)containerResolver.getRealPath("src/test/java/org/primeframework/mvc/freemarker/test_en_US.ftl")).andReturn((Object)"src/test/java/org/primeframework/mvc/freemarker/test.ftl");
        EasyMock.replay((Object[])new Object[]{containerResolver});
        LocaleProvider localeProvider = (LocaleProvider)EasyMock.createStrictMock(LocaleProvider.class);
        EasyMock.expect((Object)((Locale)localeProvider.get())).andReturn((Object)Locale.US);
        EasyMock.replay((Object[])new Object[]{localeProvider});
        DefaultFreeMarkerService defaultFreeMarkerService = new DefaultFreeMarkerService(new FreeMarkerConfigurationProvider(mVCConfiguration, (TemplateLoader)new OverridingTemplateLoader(containerResolver)).get(), localeProvider);
        StringWriter stringWriter = new StringWriter();
        defaultFreeMarkerService.render((Writer)stringWriter, "src/test/java/org/primeframework/mvc/freemarker/test.ftl", new HashMap());
        Assert.assertEquals((String)stringWriter.toString(), (String)"It worked!");
    }
}

