/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import org.apache.commons.lang3.ArrayUtils;
import org.primeframework.mvc.MockConfiguration;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.converters.NumberConverter;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NumberConverterTest {
    @Test
    public void fromStrings() {
        NumberConverter numberConverter = new NumberConverter((MVCConfiguration)new MockConfiguration());
        Byte by = (Byte)numberConverter.convertFromStrings(Byte.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}));
        Assert.assertNull((Object)by);
        Short s = (Short)numberConverter.convertFromStrings(Short.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}));
        Assert.assertNull((Object)s);
        Integer n = (Integer)numberConverter.convertFromStrings(Integer.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}));
        Assert.assertNull((Object)n);
        Long l = (Long)numberConverter.convertFromStrings(Long.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}));
        Assert.assertNull((Object)l);
        Float f = (Float)numberConverter.convertFromStrings(Float.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}));
        Assert.assertNull((Object)f);
        Double d = (Double)numberConverter.convertFromStrings(Double.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}));
        Assert.assertNull((Object)d);
        byte by2 = (Byte)numberConverter.convertFromStrings(Byte.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}));
        Assert.assertEquals((int)by2, (int)0);
        short s2 = (Short)numberConverter.convertFromStrings(Short.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}));
        Assert.assertEquals((int)s2, (int)0);
        int n2 = (Integer)numberConverter.convertFromStrings(Integer.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}));
        Assert.assertEquals((int)n2, (int)0);
        long l2 = (Long)numberConverter.convertFromStrings(Long.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}));
        Assert.assertEquals((long)l2, (long)0L);
        float f2 = ((Float)numberConverter.convertFromStrings(Float.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}))).floatValue();
        Assert.assertEquals((float)f2, (float)0.0f, (float)0.0f);
        double d2 = (Double)numberConverter.convertFromStrings(Double.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}));
        Assert.assertEquals((double)d2, (double)0.0, (double)0.0);
        by = (Byte)numberConverter.convertFromStrings(Byte.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"1"}));
        Assert.assertEquals((int)by.byteValue(), (int)1);
        s = (Short)numberConverter.convertFromStrings(Short.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"1"}));
        Assert.assertEquals((int)s.shortValue(), (int)1);
        n = (Integer)numberConverter.convertFromStrings(Integer.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"1"}));
        Assert.assertEquals((int)n, (int)1);
        l = (Long)numberConverter.convertFromStrings(Long.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"1"}));
        Assert.assertEquals((long)l, (long)1L);
        f = (Float)numberConverter.convertFromStrings(Float.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"1"}));
        Assert.assertEquals((float)1.0f, (float)f.floatValue(), (float)0.0f);
        d = (Double)numberConverter.convertFromStrings(Double.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"1"}));
        Assert.assertEquals((double)1.0, (double)d, (double)0.0);
        by = (Byte)numberConverter.convertFromStrings(Byte.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"   "}));
        Assert.assertNull((Object)by);
        s = (Short)numberConverter.convertFromStrings(Short.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"   "}));
        Assert.assertNull((Object)s);
        n = (Integer)numberConverter.convertFromStrings(Integer.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"   "}));
        Assert.assertNull((Object)n);
        l = (Long)numberConverter.convertFromStrings(Long.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"   "}));
        Assert.assertNull((Object)l);
        f = (Float)numberConverter.convertFromStrings(Float.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"   "}));
        Assert.assertNull((Object)f);
        d = (Double)numberConverter.convertFromStrings(Double.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"   "}));
        Assert.assertNull((Object)d);
        by2 = (Byte)numberConverter.convertFromStrings(Byte.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"   "}));
        Assert.assertEquals((int)by2, (int)0);
        s2 = (Short)numberConverter.convertFromStrings(Short.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"   "}));
        Assert.assertEquals((int)s2, (int)0);
        n2 = (Integer)numberConverter.convertFromStrings(Integer.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"   "}));
        Assert.assertEquals((int)n2, (int)0);
        l2 = (Long)numberConverter.convertFromStrings(Long.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"   "}));
        Assert.assertEquals((long)l2, (long)0L);
        f2 = ((Float)numberConverter.convertFromStrings(Float.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"   "}))).floatValue();
        Assert.assertEquals((float)0.0f, (float)f2, (float)0.0f);
        d2 = (Double)numberConverter.convertFromStrings(Double.TYPE, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"   "}));
        Assert.assertEquals((double)d2, (double)0.0, (double)0.0);
        try {
            numberConverter.convertFromStrings(Byte.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"bad"}));
            Assert.fail((String)"Should have failed");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            numberConverter.convertFromStrings(Short.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"bad"}));
            Assert.fail((String)"Should have failed");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            numberConverter.convertFromStrings(Integer.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"bad"}));
            Assert.fail((String)"Should have failed");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            numberConverter.convertFromStrings(Long.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"bad"}));
            Assert.fail((String)"Should have failed");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            numberConverter.convertFromStrings(Float.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"bad"}));
            Assert.fail((String)"Should have failed");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        try {
            numberConverter.convertFromStrings(Double.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"bad"}));
            Assert.fail((String)"Should have failed");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    @Test
    public void toStrings() {
        NumberConverter numberConverter = new NumberConverter((MVCConfiguration)new MockConfiguration());
        String string = numberConverter.convertToString(Integer.class, null, "testExpr", null);
        Assert.assertNull((Object)string);
        string = numberConverter.convertToString(Byte.class, null, "testExpr", (Object)42);
        Assert.assertEquals((String)string, (String)"42");
        string = numberConverter.convertToString(Byte.TYPE, null, "testExpr", (Object)42);
        Assert.assertEquals((String)string, (String)"42");
        string = numberConverter.convertToString(Short.class, null, "testExpr", (Object)42);
        Assert.assertEquals((String)string, (String)"42");
        string = numberConverter.convertToString(Short.TYPE, null, "testExpr", (Object)42);
        Assert.assertEquals((String)string, (String)"42");
        string = numberConverter.convertToString(Integer.class, null, "testExpr", (Object)42);
        Assert.assertEquals((String)string, (String)"42");
        string = numberConverter.convertToString(Integer.class, null, "testExpr", (Object)42);
        Assert.assertEquals((String)string, (String)"42");
        string = numberConverter.convertToString(Long.class, null, "testExpr", (Object)42L);
        Assert.assertEquals((String)string, (String)"42");
        string = numberConverter.convertToString(Long.TYPE, null, "testExpr", (Object)42L);
        Assert.assertEquals((String)string, (String)"42");
        string = numberConverter.convertToString(Float.class, null, "testExpr", (Object)Float.valueOf(42.0f));
        Assert.assertEquals((String)string, (String)"42.0");
        string = numberConverter.convertToString(Float.TYPE, null, "testExpr", (Object)Float.valueOf(42.0f));
        Assert.assertEquals((String)string, (String)"42.0");
        string = numberConverter.convertToString(Double.class, null, "testExpr", (Object)42.0);
        Assert.assertEquals((String)string, (String)"42.0");
        string = numberConverter.convertToString(Double.TYPE, null, "testExpr", (Object)42.0);
        Assert.assertEquals((String)string, (String)"42.0");
    }
}

