/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.util;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class QueryStringBuilder {
    private final StringBuilder sb = new StringBuilder();
    private final List<String> segments = new ArrayList<String>();
    private final StringBuilder uri = new StringBuilder();
    private boolean addSeparator;

    protected QueryStringBuilder() {
    }

    protected QueryStringBuilder(String uri) {
        this.uri(uri);
    }

    public static QueryStringBuilder builder() {
        return new QueryStringBuilder();
    }

    public static QueryStringBuilder builder(String uri) {
        return new QueryStringBuilder(uri);
    }

    public QueryStringBuilder beginFragment() {
        if (this.sb.indexOf("#") == -1) {
            this.sb.append("#");
            this.addSeparator = false;
        } else {
            char lastChar = this.sb.charAt(this.sb.length() - 1);
            this.addSeparator = lastChar != '#' && lastChar != '&';
        }
        return this;
    }

    public QueryStringBuilder beginQuery() {
        if (this.sb.indexOf("#") != -1) {
            throw new IllegalStateException("You cannot add a query after a fragment");
        }
        if (this.sb.indexOf("?") == -1) {
            this.sb.append("?");
            this.addSeparator = false;
        } else {
            char lastChar = this.sb.charAt(this.sb.length() - 1);
            this.addSeparator = lastChar != '?' && lastChar != '&';
        }
        return this;
    }

    public String build() {
        if (this.uri.isEmpty()) {
            return this.sb.toString();
        }
        if (this.segments.size() > 0) {
            if (this.uri.lastIndexOf("/") != this.uri.length() - 1) {
                this.uri.append("/");
            }
            this.uri.append(String.join((CharSequence)"/", this.segments));
        }
        if (this.sb.indexOf("?") == 0 || this.sb.indexOf("#") == 0) {
            return this.uri.append((CharSequence)this.sb).toString();
        }
        if (this.sb.isEmpty()) {
            return this.uri.toString();
        }
        return this.uri.append("?").append((CharSequence)this.sb).toString();
    }

    public QueryStringBuilder ifFalse(boolean test, Runnable runnable) {
        if (!test) {
            runnable.run();
        }
        return this;
    }

    public QueryStringBuilder ifFalse(boolean test, Consumer<QueryStringBuilder> consumer) {
        if (!test) {
            consumer.accept(this);
        }
        return this;
    }

    public QueryStringBuilder ifTrue(boolean test, Runnable runnable) {
        if (test) {
            runnable.run();
        }
        return this;
    }

    public QueryStringBuilder ifTrue(boolean test, Consumer<QueryStringBuilder> consumer) {
        if (test) {
            consumer.accept(this);
        }
        return this;
    }

    public QueryStringBuilder uri(String uri) {
        if (!this.uri.isEmpty()) {
            throw new IllegalStateException("Object has already been initialized with a URL");
        }
        if (uri != null) {
            String del = null;
            if (uri.contains("?")) {
                del = "?";
            } else if (uri.contains("#")) {
                del = "#";
            }
            if (del != null) {
                this.uri.append(uri, 0, uri.indexOf(del));
                this.sb.append(uri, uri.indexOf(del), uri.length());
            } else {
                this.uri.append(uri);
            }
            if ((uri.contains("?") || uri.contains("#")) && !List.of(Character.valueOf('#'), Character.valueOf('?'), Character.valueOf('&')).contains(Character.valueOf(uri.charAt(uri.length() - 1)))) {
                this.addSeparator = true;
            }
        }
        return this;
    }

    public QueryStringBuilder with(String name, Consumer<QueryStringBuilder> consumer) {
        QueryStringBuilder b = new QueryStringBuilder();
        consumer.accept(b);
        return this.with(name, b);
    }

    public QueryStringBuilder with(String name, Object value) {
        if (value == null) {
            return this;
        }
        if (this.addSeparator) {
            this.sb.append("&");
        }
        this.sb.append(URLEncoder.encode(name, StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(value.toString(), StandardCharsets.UTF_8));
        this.addSeparator = true;
        return this;
    }

    public QueryStringBuilder withActual(String name) {
        throw new UnsupportedOperationException();
    }

    public QueryStringBuilder withSegment(Object segment) {
        String message = "You cannot add a URL segment after you have appended a %s to the end of the URL";
        if (!this.sb.isEmpty()) {
            if (this.sb.indexOf("?") != -1) {
                throw new IllegalStateException(String.format(message, "?"));
            }
            if (this.sb.indexOf("#") != -1) {
                throw new IllegalStateException(String.format(message, "#"));
            }
        }
        if (segment != null) {
            this.segments.add(segment.toString());
        }
        return this;
    }
}

