/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.scope;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.lang.annotation.Annotation;
import org.primeframework.mvc.ErrorException;
import org.primeframework.mvc.scope.AbstractCookieScope;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.util.CookieTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBrowserSessionScope<T extends Annotation>
extends AbstractCookieScope<T> {
    private static final Logger logger = LoggerFactory.getLogger(BaseBrowserSessionScope.class);
    protected final Encryptor encryptor;
    protected final ObjectMapper objectMapper;

    protected BaseBrowserSessionScope(HTTPRequest request, HTTPResponse response, Encryptor encryptor, ObjectMapper objectMapper) {
        super(request, response);
        this.encryptor = encryptor;
        this.objectMapper = objectMapper;
    }

    @Override
    protected Cookie buildCookie(String fieldName, Object value, T scope) {
        if (value == null) {
            return null;
        }
        boolean compress = this.compress(scope);
        boolean encrypt = this.encrypt(scope);
        try {
            String cookieValue = CookieTools.toJSONCookie(value, compress, encrypt, this.encryptor, this.objectMapper);
            Cookie cookie = new Cookie(this.getCookieName(fieldName, scope), cookieValue);
            this.setCookieValues(cookie, scope);
            return cookie;
        }
        catch (Exception e) {
            throw new ErrorException("error", (Throwable)e, new Object[0]);
        }
    }

    protected abstract boolean compress(T var1);

    protected abstract boolean encrypt(T var1);

    @Override
    protected Object processCookie(Cookie cookie, String fieldName, Class<?> type, T scope) {
        String value;
        String string = value = cookie != null ? cookie.value : null;
        if (value == null || "".equals(value)) {
            return null;
        }
        boolean encrypt = this.encrypt(scope);
        try {
            return CookieTools.fromJSONCookie(value, type, encrypt, encrypt, this.encryptor, this.objectMapper);
        }
        catch (Exception e) {
            String message = e.getClass().getCanonicalName() + " " + e.getMessage();
            if (encrypt) {
                logger.debug("Failed to decrypt cookie. This may be expected if the cookie was encrypted using a different key.\n\tCause: {}", (Object)message);
            } else {
                logger.debug("Failed to decode cookie. This is not expected.\n\tCause: {}", (Object)message);
            }
            return null;
        }
    }

    protected abstract void setCookieValues(Cookie var1, T var2);
}

