/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.el;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.parameter.convert.ConverterProvider;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.parameter.convert.GlobalConverter;
import org.primeframework.mvc.parameter.el.Accessor;
import org.primeframework.mvc.parameter.el.ExpressionException;
import org.primeframework.mvc.parameter.el.IndexExpressionException;
import org.primeframework.mvc.parameter.el.IndexedAccessor;
import org.primeframework.mvc.parameter.el.IndexedCollectionAccessor;
import org.primeframework.mvc.parameter.el.InvalidExpressionException;
import org.primeframework.mvc.parameter.el.MapAccessor;
import org.primeframework.mvc.parameter.el.MemberAccessor;

public class Expression {
    private final List<String> atoms;
    private final Map<String, String> attributes;
    private final MVCConfiguration configuration;
    private final ConverterProvider converterProvider;
    private final String expression;
    private Accessor accessor;
    private Object current;
    private int index;
    private Class<?> type;

    public Expression(ConverterProvider converterProvider, String expression, Object current, Map<String, String> attributes, MVCConfiguration configuration) {
        this.expression = expression;
        this.attributes = attributes;
        this.converterProvider = converterProvider;
        this.atoms = this.parse(expression);
        this.configuration = configuration;
        this.setCurrentObject(current);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Accessor getCurrentAccessor() {
        return this.accessor;
    }

    public Object getCurrentObject() {
        return this.current;
    }

    private void setCurrentObject(Object object) {
        this.current = object;
        this.type = object.getClass();
    }

    public String getCurrentValueAsString() {
        Class<?> type = this.current.getClass();
        GlobalConverter converter = this.converterProvider.lookup(type);
        if (converter == null) {
            throw new ConverterStateException("No type converter found for the type [" + String.valueOf(type) + "]");
        }
        return converter.convertToString(type, this.attributes, this.expression, this.current);
    }

    public String getExpression() {
        return this.expression;
    }

    public Object traverseToEndForGet() {
        while (this.hasNext()) {
            this.next();
            Object value = this.getCurrentValue();
            if (value == null) {
                return null;
            }
            this.setCurrentObject(value);
        }
        return this.getCurrentObject();
    }

    public void traverseToEndForSet() {
        while (this.hasNext()) {
            this.next();
            if (!this.hasNext()) continue;
            Object value = this.getCurrentValue();
            if (value == null) {
                value = this.createValue();
            }
            if (value == null) continue;
            this.setCurrentObject(value);
        }
    }

    private Object createValue() {
        String key = this.hasNext() ? this.peek() : null;
        Object value = this.accessor.createValue(key);
        this.setCurrentValue(value);
        return value;
    }

    private Object getCurrentValue() {
        return this.accessor.get(this.current, this);
    }

    public void setCurrentValue(String[] values) {
        try {
            this.accessor.set(this.current, values, this);
        }
        catch (UnsupportedOperationException e) {
            if (this.configuration.allowUnknownParameters()) {
                return;
            }
            throw e;
        }
    }

    public void setCurrentValue(Object value) {
        try {
            this.accessor.set(this.current, value, this);
        }
        catch (UnsupportedOperationException e) {
            if (this.configuration.allowUnknownParameters()) {
                return;
            }
            throw e;
        }
    }

    private boolean hasNext() {
        return this.index < this.atoms.size();
    }

    private void next() {
        String atom = this.atoms.get(this.index++);
        if (this.accessor != null && this.accessor.isIndexed()) {
            this.accessor = new IndexedAccessor(this.converterProvider, (MemberAccessor)this.accessor, atom);
        } else if (Collection.class.isAssignableFrom(this.type) || this.current.getClass().isArray()) {
            GlobalConverter converter = this.converterProvider.lookup(Integer.class);
            Integer index = (Integer)converter.convertFromStrings((Type)((Object)Integer.class), null, null, atom);
            this.accessor = new IndexedCollectionAccessor(this.converterProvider, this.accessor, index, this.accessor.getMemberAccessor());
        } else {
            this.accessor = Map.class.isAssignableFrom(this.type) ? new MapAccessor(this.converterProvider, this.accessor, atom, this.accessor.getMemberAccessor()) : new MemberAccessor(this.converterProvider, this.type, atom, this.expression, this.configuration);
        }
        while (this.skip()) {
            if (!this.hasNext()) {
                throw new IndexExpressionException("Encountered an indexed property without an index in the expression [" + this.expression + "]");
            }
            this.next();
        }
    }

    private List<String> parse(String expression) throws ExpressionException {
        char[] ca = expression.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        int position = 0;
        int openBracket = 0;
        char[] buf = new char[128];
        boolean insideBracket = false;
        boolean insideQuote = false;
        for (int index = 0; index < ca.length; ++index) {
            if (ca[index] == '.' && !insideQuote) {
                if (insideBracket || insideQuote) {
                    throw new InvalidExpressionException("The expression string [" + expression + "] contains an invalid indices");
                }
                if (position == 0) {
                    throw new InvalidExpressionException("The expression string [" + expression + "] is invalid.");
                }
                list.add(new String(buf, 0, position));
                position = 0;
                continue;
            }
            if (ca[index] == '[' && !insideQuote) {
                if (insideBracket) {
                    throw new InvalidExpressionException("The expression string [" + expression + "] contains an invalid indices");
                }
                list.add(new String(buf, 0, position));
                insideBracket = true;
                position = 0;
                openBracket = index;
                continue;
            }
            if (ca[index] == ']' && !insideQuote) {
                if (!insideBracket) {
                    throw new InvalidExpressionException("The expression string [" + expression + "] contains an invalid indices");
                }
                if (position == 0 && index - openBracket == 1) {
                    list.add(null);
                } else {
                    list.add(new String(buf, 0, position));
                }
                if (index + 1 < ca.length && ca[index + 1] == '.') {
                    ++index;
                }
                insideBracket = false;
                position = 0;
                continue;
            }
            if (ca[index] == '\'' || ca[index] == '\"') {
                if (!insideBracket) {
                    throw new InvalidExpressionException("The expression string [" + expression + "] is invalid.");
                }
                insideQuote = !insideQuote;
                continue;
            }
            if (position == buf.length) {
                if (buf.length >= 32768) {
                    throw new InvalidExpressionException("The expression token [" + new String(buf, 0, position) + "] is too long");
                }
                char[] newBuf = new char[buf.length + 128];
                System.arraycopy(buf, 0, newBuf, 0, position);
                buf = newBuf;
            }
            buf[position++] = ca[index];
        }
        if (position > 0) {
            list.add(new String(buf, 0, position));
        }
        for (String atom : list) {
            if (!"class".equals(atom)) continue;
            throw new InvalidExpressionException("The expression string [" + expression + "] is invalid.");
        }
        return list;
    }

    private String peek() {
        return this.atoms.get(this.index);
    }

    private boolean skip() {
        return this.accessor != null && this.accessor.isIndexed();
    }
}

