/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.message.l10n;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.container.ContainerResolver;

public class WebControl
extends ResourceBundle.Control {
    private final MVCConfiguration configuration;
    private final ContainerResolver containerResolver;
    private final long reloadCheckSeconds;

    @Inject
    public WebControl(ContainerResolver containerResolver, MVCConfiguration configuration) {
        this.configuration = configuration;
        this.containerResolver = containerResolver;
        this.reloadCheckSeconds = configuration.l10nReloadSeconds();
    }

    @Override
    public Locale getFallbackLocale(String uri, Locale locale) {
        return null;
    }

    @Override
    public List<String> getFormats(String uri) {
        return Collections.singletonList("java.properties");
    }

    @Override
    public long getTimeToLive(String baseName, Locale locale) {
        return this.reloadCheckSeconds * 1000L;
    }

    @Override
    public boolean needsReload(String uri, Locale locale, String format, ClassLoader loader, ResourceBundle bundle, long loadTime) {
        String name = this.name(uri, locale);
        String realPath = this.containerResolver.getRealPath(name);
        if (realPath != null) {
            File file = new File(realPath);
            long time = file.lastModified();
            return time > loadTime;
        }
        return false;
    }

    @Override
    public ResourceBundle newBundle(String uri, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException {
        File file;
        String name = this.name(uri, locale);
        String realPath = this.containerResolver.getRealPath(name);
        if (realPath != null && (file = new File(realPath)).isFile()) {
            return new PropertyResourceBundle(new FileInputStream(file));
        }
        URL url = this.containerResolver.getResource(name);
        if (url == null) {
            url = loader.getResource(name.substring(1));
        }
        if (url != null) {
            return new PropertyResourceBundle(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
        }
        throw new PrimeException("Invalid bundle [" + uri + "]");
    }

    private String name(String uri, Locale locale) {
        if (((String)uri).endsWith("/")) {
            uri = (String)uri + "index";
        }
        return this.configuration.messageDirectory() + this.toBundleName((String)uri, locale) + ".properties";
    }
}

