/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.content.json;

import io.fusionauth.http.HTTPMethod;
import java.lang.reflect.Method;
import java.util.Map;
import org.primeframework.mvc.content.json.annotation.JSONPatch;
import org.primeframework.mvc.content.json.annotation.JSONResponse;

public class JacksonActionConfiguration {
    public final JSONPropertyFilterConfig jsonPropertyFilterConfig;
    public final Map<HTTPMethod, RequestMember> requestMembers;
    public final ResponseMember responseMember;

    public JacksonActionConfiguration(Map<HTTPMethod, RequestMember> requestMembers, ResponseMember responseMember, JSONPropertyFilterConfig jsonPropertyFilterConfig) {
        this.jsonPropertyFilterConfig = jsonPropertyFilterConfig;
        this.requestMembers = requestMembers;
        this.responseMember = responseMember;
    }

    public Class<?> getSerializationView() {
        if (this.responseMember == null || this.responseMember.annotation == null) {
            return null;
        }
        return this.responseMember.annotation.view();
    }

    public static class JSONPropertyFilterConfig {
        public final Method method;
        public final Class<?> mixinSource;
        public final Class<?> mixinTarget;
        public final String name;

        public JSONPropertyFilterConfig(Method method, String name, Class<?> mixinSource, Class<?> mixinTarget) {
            this.method = method;
            this.mixinSource = mixinSource == Object.class ? null : mixinSource;
            this.mixinTarget = mixinTarget == Object.class ? null : mixinTarget;
            this.name = name;
        }
    }

    public static class ResponseMember {
        public JSONResponse annotation;
        public String name;

        public ResponseMember(JSONResponse annotation, String name) {
            this.annotation = annotation;
            this.name = name;
        }
    }

    public static class RequestMember {
        public JSONPatch jsonPatch;
        public String name;
        public Class<?> type;

        public RequestMember(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public RequestMember(String name, Class<?> type, JSONPatch jsonPatch) {
            this.name = name;
            this.type = type;
            this.jsonPatch = jsonPatch;
        }
    }
}

